/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'mage/translate',
    'mage/storage',
    'ko',
    'uiComponent',
    'Magento_QuickCheckout/js/model/customer/customer',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/checkout-data',
    'Magento_QuickCheckout/js/model/account-handling',
    'Magento_Checkout/js/model/full-screen-loader',
    'Magento_Customer/js/model/customer',
    'Magento_Customer/js/customer-data',
    'Magento_Ui/js/model/messageList',
    'Magento_QuickCheckout/js/action/get-account-details'
], function (
    $,
    $t,
    storage,
    ko,
    Component,
    boltCustomer,
    quote,
    checkoutData,
    bolt,
    fullScreenLoader,
    customer,
    customerData,
    globalMessageList,
    getAccountDetails
) {
    'use strict';

    var getCustomerEmail = function () {
        return customer.isLoggedIn() ? customer.customerData.email : quote.guestEmail;
    };

    return Component.extend({
        defaults: {
            template: 'Magento_QuickCheckout/logout-info',
            visible: boltCustomer.isBoltUser,
            boltLogoutInfo: $t('Logged in to Bolt as'),
            quoteEmail: ko.observable(getCustomerEmail()),
            ajaxLogoutUrl: 'customer/ajax/logout',
            ajaxBoltLogoutUrl: 'quick-checkout/ajax/logout'
        },

        /**
         * @inheritdoc
         */
        initialize: function () {
            var self = this;

            this._super();
            boltCustomer.isBoltUser.subscribe(function () {
                if (boltCustomer.isBoltUser()) {
                    self.quoteEmail(getCustomerEmail());
                }
                self.visible(boltCustomer.isBoltUser());
            });

            if (
                window.checkoutConfig.payment.quick_checkout.isLoggedInBolt &&
                !checkoutData.getAccountInformationLoaded()) {
                getAccountDetails();
            }

            return this;
        },

        /**
         * Logout Bolt user and clean up checkout data
         */
        logoutBolt: function () {
            var self = this,
                logoutUrl = customer.isLoggedIn() ? self.ajaxLogoutUrl : self.ajaxBoltLogoutUrl,
                defaultError = $t('Could not logout. Please try again later.');

            fullScreenLoader.startLoader();

            bolt.clearCheckoutData();
            bolt.clearBoltCheckoutData();
            checkoutData.setLoggedOut(true);

            storage.get(
                logoutUrl
            ).done(function () {
                customerData.invalidate(['customer']);
                window.location = window.checkoutConfig.checkoutUrl;
            }).fail(function () {
                globalMessageList.addErrorMessage({'message': defaultError});
            }).always(function () {
                fullScreenLoader.stopLoader();
            });
        }
    });
});
