/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'ko',
    'Magento_Checkout/js/checkout-data'
], function (ko, checkoutData) {
    'use strict';

    var isBoltUser = ko.observable(
        checkoutData.getBoltAccountDetails() !== null && typeof checkoutData.getBoltAccountDetails() !== 'undefined'
    ),
        hasBoltAccount = ko.observable(checkoutData.getHasBoltAccount()).extend({ notify: 'always' });

    return {
        isBoltUser: isBoltUser,
        hasBoltAccount: hasBoltAccount,

        /**
         * @param {Boolean} flag
         */
        setIsLoggedIn: function (flag) {
            isBoltUser(flag);
            if (flag) {
                this.setHasBoltAccount(flag);
            }
        },

        /**
         * @param {Boolean} flag
         */
        setHasBoltAccount: function (flag) {
            hasBoltAccount(flag);
            checkoutData.setHasBoltAccount(flag);
        }
    };
});
