/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'mage/translate',
    'ko',
    'uiComponent',
    'Magento_QuickCheckout/js/model/customer/customer',
    'Magento_Checkout/js/model/quote',
    'Magento_Checkout/js/checkout-data',
    'Magento_QuickCheckout/js/model/account-handling',
    'Magento_Checkout/js/model/full-screen-loader'
], function (
    $,
    $t,
    ko,
    Component,
    boltCustomer,
    quote,
    checkoutData,
    bolt,
    fullScreenLoader
) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Magento_QuickCheckout/logout-info',
            visible: boltCustomer.isBoltUser,
            boltLogoutInfo: $t('Logged in to Bolt as'),
            quoteEmail: ko.observable(quote.guestEmail)
        },

        /**
         * @inheritdoc
         */
        initialize: function () {
            var self = this;

            this._super();
            boltCustomer.isBoltUser.subscribe(function () {
                if (boltCustomer.isBoltUser()) {
                    self.quoteEmail(quote.guestEmail);
                }
                self.visible(boltCustomer.isBoltUser());
            });

            return this;
        },

        /**
         * Logout Bolt user and clean up checkout data
         */
        logoutBolt: function () {
            fullScreenLoader.startLoader();
            bolt.clearCheckoutData();
            bolt.clearBoltCheckoutData();
            checkoutData.setLoggedOut(true);
            window.location = window.checkoutConfig.checkoutUrl;
        }
    });
});
