/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define([
    'jquery',
    'Magento_QuickCheckout/js/action/get-account-details'
], function ($, getAccountDetailsAction) {
    'use strict';

    return function (email) {
        var locale = window.checkoutConfig.payment['quick_checkout'].locale,
            boltEmbedded = window.Bolt(
                window.checkoutConfig.payment['quick_checkout'].publishableKey
            ),
            authorizationComponent = boltEmbedded.create(
                'authorization_component',
                {
                    language: locale,
                    style: {
                        position: 'right'
                    }
                }
            ),
            customerEmailFieldsetSelector = '#customer-email-fieldset',
            authorizationCode = '';

        if ($(customerEmailFieldsetSelector).is(':visible') === false) {
            return;
        }

        authorizationComponent
            .mount(customerEmailFieldsetSelector)
            .then(function () {
                authorizationComponent
                    .authorize({ email: email })
                    .then(function (data) {
                        authorizationComponent.unmount();
                        if (typeof data !== 'undefined') {
                            authorizationCode = data.authorizationCode;
                            getAccountDetailsAction(authorizationCode);
                        }
                    });
            });
    };
});
