/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
define([
    'Magento_Checkout/js/model/quote',
    'mage/utils/wrapper',
    'Magento_QuickCheckout/js/model/account-handling'
], function (quote, wrapper, bolt) {
    'use strict';
    return function (placeOrderAction) {
        /** Override default place order action and clean up bolt data in billing address  */
        return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, messageContainer) {
            if (bolt.getBillingAddressBoltId()) {
                delete quote.billingAddress().extensionAttributes.boltId;
                if (typeof quote.billingAddress().extensionAttributes === 'object') {
                    quote.billingAddress().extensionAttributes = undefined;
                }
            }
            return originalAction(paymentData, messageContainer);
        });
    };
});
