<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\QuickCheckout\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Framework\Locale\ResolverInterface;

/**
 * Provide configuration for checkout components
 */
class ConfigProvider implements ConfigProviderInterface
{
    public const CODE = 'quick_checkout';

    /**
     * @var Config
     */
    private $config;

    /**
     * @var ResolverInterface
     */
    private $localeResolver;

    /**
     * @param Config $config
     * @param ResolverInterface $localeResolver
     */
    public function __construct(
        Config $config,
        ResolverInterface $localeResolver
    ) {
        $this->config = $config;
        $this->localeResolver = $localeResolver;
    }

    /**
     * @inheritdoc
     */
    public function getConfig(): array
    {
        if (!$this->config->isEnabled()) {
            return [];
        }
        return [
            'payment' => [
                self::CODE => [
                    'publishableKey' => $this->config->getPublishableKey(),
                    'locale' => str_replace('_', '-', $this->localeResolver->getLocale()),
                    'canDisplayOtpPopup' => $this->config->canDisplayOtpPopup(),
                    'creditCardComponentConfig' => $this->config->getCreditCardFormConfig()
                ]
            ]
        ];
    }
}
