<?php

/**
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2023 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */

declare(strict_types=1);

namespace Magento\PaymentServicesPaypal\Setup\Patch\Data;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

/**
 * Update new smart buttons configuration based on the previous
 */
class UpdateButtonsConfiguration implements DataPatchInterface
{
    private const VENMO_CONFIG = 'payment/payment_services_paypal_smart_buttons/funding_venmo';
    private const NEW_VENMO_CONFIGS = [
        'payment/payment_services_paypal_smart_buttons/display_checkout_venmo',
        'payment/payment_services_paypal_smart_buttons/display_cart_venmo',
        'payment/payment_services_paypal_smart_buttons/display_minicart_venmo',
        'payment/payment_services_paypal_smart_buttons/display_product_detail_venmo',
    ];
    private const PAY_LATER_CONFIG = 'payment/payment_services_paypal_smart_buttons/funding_paypal_credit';
    private const NEW_PAY_LATER_CONFIGS = [
        'payment/payment_services_paypal_smart_buttons/display_checkout_paypal_credit',
        'payment/payment_services_paypal_smart_buttons/display_cart_paypal_credit',
        'payment/payment_services_paypal_smart_buttons/display_minicart_paypal_credit',
        'payment/payment_services_paypal_smart_buttons/display_product_detail_paypal_credit',
    ];
    private const PAY_LATER_MESSAGE_CONFIG = 'payment/payment_services_paypal_smart_buttons/display_paylater_message';
    private const NEW_PAY_LATER_MESSAGE_CONFIGS = [
        'payment/payment_services_paypal_smart_buttons/display_checkout_paylater_message',
        'payment/payment_services_paypal_smart_buttons/display_cart_paylater_message',
        'payment/payment_services_paypal_smart_buttons/display_minicart_paylater_message',
        'payment/payment_services_paypal_smart_buttons/display_product_detail_paylater_message',
    ];

    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * @inheritdoc
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();

        $this->updateConfiguration(self::VENMO_CONFIG, self::NEW_VENMO_CONFIGS);
        $this->updateConfiguration(self::PAY_LATER_CONFIG, self::NEW_PAY_LATER_CONFIGS);
        $this->updateConfiguration(self::PAY_LATER_MESSAGE_CONFIG, self::NEW_PAY_LATER_MESSAGE_CONFIGS);

        return $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * Update value of new configuration base on store specific old values
     *
     * @param string $config
     * @param array $newConfigs
     * @return void
     */
    private function updateConfiguration(string $config, array $newConfigs)
    {
        $connection = $this->moduleDataSetup->getConnection();
        $table = $this->moduleDataSetup->getTable('core_config_data');
        $select = $connection->select()
            ->from(
                $table,
                ['config_id', 'scope', 'scope_id', 'value']
            )
            ->where('path = ?', $config);

        $configValues = $connection->fetchAll($select);

        // Loop through all stores specific config
        foreach ($configValues as $configValue) {

            // Loop through all new configs, update OR insert new config values
            foreach ($newConfigs as $newConfigPath) {
                $data = [
                    'scope' => $configValue['scope'],
                    'scope_id' => $configValue['scope_id'],
                    'path' => $newConfigPath,
                    'value' => $configValue['value']
                ];
                $connection->insertOnDuplicate(
                    $table,
                    $data,
                    ['value']
                );
            }

            // Delete old configs
            $connection->delete($table, ['config_id = ?' => $configValue['config_id']]);
        }
    }
}
