<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\PaymentServicesPaypal\Plugin\Config;

use Magento\PaymentServicesPaypal\Model\HostedFieldsConfigProvider;
use Magento\PaymentServicesPaypal\Model\SmartButtonsConfigProvider;
use Magento\Payment\Model\Method\Adapter as PaymentAdapter;
use Magento\PaymentServicesPaypal\Model\Config;

class Adapter
{
    /**
     * @var Config
     */
    private $config;

    /**
     * @param Config $config
     */
    public function __construct(
        Config $config
    ) {
        $this->config = $config;
    }

    /**
     * Return isActive for payment methods based on whether payments is enabled
     *
     * @param PaymentAdapter $subject
     * @param bool $result
     * @return bool
     */
    public function afterIsActive(PaymentAdapter $subject, bool $result): bool
    {
        if (in_array($subject->getCode(), [
            HostedFieldsConfigProvider::CODE,
            SmartButtonsConfigProvider::CODE,
        ])) {
            return $this->config->isEnabled();
        } elseif ($subject->getCode() === HostedFieldsConfigProvider::CC_VAULT_CODE) {
            return $this->config->isEnabled() && $this->config->isVaultEnabled();
        } else {
            return $result;
        }
    }
}
