<?php

/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

declare(strict_types=1);

namespace Magento\PaymentServicesPaypal\Plugin\Vault;

use Magento\Vault\Model\Method\Vault as VaultMethod;
use Magento\PaymentServicesPaypal\Model\HostedFieldsConfigProvider;

class Method
{
    /**
     * Return false for can_use_internal for payment services vault on admin checkout
     *
     * This plugin needs to be REMOVED after admin checkout is implemented
     *
     * @param VaultMethod $subject
     * @param bool $result
     * @return bool|false
     */
    public function afterCanUseInternal(VaultMethod $subject, bool $result)
    {
        if ($subject->getCode() === HostedFieldsConfigProvider::CC_VAULT_CODE) {
            return false;
        }
        return $result;
    }
}
