<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\PaymentServicesPaypal\Block;

use Magento\Framework\View\Element\Template\Context;
use Magento\PaymentServicesPaypal\Model\Config;

/**
 * @api
 */
class SmartButtonsProduct extends SmartButtons
{
    /**
     * @var string
     */
    private $pageType;

    /**
     * @param Context $context
     * @param Config $config
     * @param string $pageType
     * @param array $componentConfig
     * @param array $data
     */
    public function __construct(
        Context $context,
        Config $config,
        string $pageType = 'minicart',
        array $componentConfig = [],
        array $data = []
    ) {
        $this->pageType = $pageType;
        parent::__construct(
            $context,
            $config,
            $pageType,
            $componentConfig,
            $data
        );
    }

    /**
     * Get the component params of Smart Buttons
     *
     * @return array[]
     */
    public function getComponentParams() : array
    {
        return array_merge(
            parent::getComponentParams(),
            [
                // phpcs:disable Magento2.Files.LineLength, Generic.Files.LineLength
                'createOrderUrl' => $this->getUrl('paymentservicespaypal/smartbuttons/createpaypalorder', ['location' => $this->pageType]),
                'cancelUrl' => $this->getUrl('paymentservicespaypal/smartbuttons/cancel'),
                'addToCartUrl' => $this->getUrl('paymentservicespaypal/smartbuttons/addtocart'),
            ]
        );
    }
}
