<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\PaymentServicesPaypal\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\PaymentServicesPaypal\Model\SdkService\PaymentOptionsBuilderFactory;
use Magento\Framework\UrlInterface;

class SmartButtonsConfigProvider extends AbstractConfigProvider implements ConfigProviderInterface
{
    public const CODE = 'payment_services_paypal_smart_buttons';

    /**
     * @var Config
     */
    private $config;

    /**
     * @var array
     */
    private $messageStyles;

    /**
     * @var UrlInterface
     */
    private $url;

    /**
     * SmartButtonsConfigProvider constructor.
     * @param Config $config
     * @param PaymentOptionsBuilderFactory $paymentOptionsBuilderFactory
     * @param SdkService $sdkService
     * @param UrlInterface $url
     * @param array $messageStyles
     */
    public function __construct(
        Config $config,
        PaymentOptionsBuilderFactory $paymentOptionsBuilderFactory,
        SdkService $sdkService,
        UrlInterface $url,
        array $messageStyles
    ) {
        $this->config = $config;
        $this->url = $url;
        $this->messageStyles = $messageStyles;
        parent::__construct($config, $paymentOptionsBuilderFactory, $sdkService);
    }

    /**
     * {@inheritdoc}
     */
    public function getConfig()
    {
        $config = parent::getConfig();
        if (!$this->config->isEnabled()) {
            return $config;
        }
        $config['payment'][self::CODE]['createOrderUrl'] = $this->url->getUrl('paymentservicespaypal/order/create');
        $config['payment'][self::CODE]['sdkParams'] = $this->getScriptParams();
        $config['payment'][self::CODE]['messageStyles'] = $this->messageStyles;
        $config['payment'][self::CODE]['canDisplayMessage'] = (bool) $this->config->canDisplayPayLaterMessage();
        return $config;
    }
}
