<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\PaymentServicesPaypal\Model;

use Magento\PaymentServicesBase\Model\Config as BaseConfig;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class Config
{
    /**
     * @var BaseConfig
     */
    private $config;

    /**
     * @var ScopeConfigInterface
     */
    private $scopeConfig;

    /**
     * @param BaseConfig $config
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        BaseConfig $config,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->config = $config;
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * @return string
     */
    public function getMerchantId($environment = '') : string
    {
        return $this->config->getMerchantId($environment);
    }

    /**
     * @return bool
     */
    public function isEnabled() : bool
    {
        return $this->config->isEnabled();
    }

    /**
     * @return bool
     */
    public function canDisplayPayLaterMessage() : bool
    {
        return (bool) $this->scopeConfig->getValue(
            'payment/payment_services_paypal_smart_buttons/display_paylater_message',
            ScopeInterface::SCOPE_STORE,
            null
        );
    }
}
