<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Magento\PaymentServicesPaypal\Controller\SmartButtons;

use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Controller\ResultInterface;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\App\Request\InvalidRequestException;
use Magento\PaymentServicesPaypal\Model\SmartButtons\Checkout;
use Magento\Framework\Session\Generic as PaypalSession;
use Magento\Framework\Exception\LocalizedException;
use Exception;

class CreatePaypalOrder implements HttpPostActionInterface, CsrfAwareActionInterface
{
    /**
     * @var Checkout
     */
    private $checkout;

    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @var ResultFactory
     */
    private $resultFactory;

    /**
     * @param RequestInterface $request
     * @param ResultFactory $resultFactory
     * @param Checkout $checkout
     */
    public function __construct(
        RequestInterface $request,
        ResultFactory $resultFactory,
        Checkout $checkout
    ) {
        $this->request = $request;
        $this->resultFactory = $resultFactory;
        $this->checkout = $checkout;
    }

    /**
      * @return ResultInterface
     */
    public function execute() : ResultInterface
    {
        $error = false;
        $result = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        try {
            $this->checkout->setLocation($this->request->getParam('location'));
            $this->checkout->validateQuote();
            try {
                $response = $this->checkout->createPayPalOrder();
            } catch (LocalizedException | Exception $e) {
                $error = __('Can\'t create PayPal order. Please try again.');
            }
        } catch (LocalizedException $e) {
            $error = $e->getMessage();
        }
        if (!$error) {
            $result->setHttpResponseCode($response['status'])
                ->setData(['response' => $response]);
        } else {
            $result->setHttpResponseCode(500)
                ->setData(
                    [
                        'response' => [
                            'error' => $error
                        ]
                    ]
                );
            }
        return $result;
    }

    public function createCsrfValidationException(RequestInterface $request) :? InvalidRequestException
    {
        return null;
    }

    public function validateForCsrf(RequestInterface $request) :? bool
    {
        return true;
    }
}
