<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace Magento\PaymentServicesDashboard\Block\Adminhtml\System\Config;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

/**
 * @api
 */
class MagentoPaymentsButton extends Field
{

    /**
     * @ingeritdoc
     */
    protected function _prepareLayout()
    {
        parent::_prepareLayout();
        $this->setTemplate('Magento_PaymentServicesDashboard::adminhtml/system/config/magento_payments_button.phtml');
        return $this;
    }

    /**
     * @ingeritdoc
     */
    public function render(AbstractElement $element)
    {
        $element = clone $element;
        $element->unsScope()
            ->unsCanUseWebsiteValue()
            ->unsCanUseDefaultValue();
        return parent::render($element);
    }

    /**
     * @ingeritdoc
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $originalData = $element->getOriginalData();
        $buttonLabel = $originalData['button_label'];
        $this->addData(
            [
                'label' => __($buttonLabel),
                'html_id' => $element->getHtmlId(),
                'magento_payments_url' => $this->getUrl('paymentservicesdashboard/dashboard/index'),
            ]
        );
        return $this->_toHtml();
    }
}
