/*!
 * Name    : Just Another Parallax [Jarallax]
 * Version : 1.12.0
 * Author  : nK <https://nkdev.info>
 * GitHub  : https://github.com/nk-o/jarallax
 */
/******/ (function(modules) { // webpackBootstrap
    /******/ 	// The module cache
    /******/ 	var installedModules = {};
    /******/
    /******/ 	// The require function
    /******/ 	function __webpack_require__(moduleId) {
        /******/
        /******/ 		// Check if module is in cache
        /******/ 		if(installedModules[moduleId]) {
            /******/ 			return installedModules[moduleId].exports;
            /******/ 		}
        /******/ 		// Create a new module (and put it into the cache)
        /******/ 		var module = installedModules[moduleId] = {
            /******/ 			i: moduleId,
            /******/ 			l: false,
            /******/ 			exports: {}
            /******/ 		};
        /******/
        /******/ 		// Execute the module function
        /******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
        /******/
        /******/ 		// Flag the module as loaded
        /******/ 		module.l = true;
        /******/
        /******/ 		// Return the exports of the module
        /******/ 		return module.exports;
        /******/ 	}
    /******/
    /******/
    /******/ 	// expose the modules object (__webpack_modules__)
    /******/ 	__webpack_require__.m = modules;
    /******/
    /******/ 	// expose the module cache
    /******/ 	__webpack_require__.c = installedModules;
    /******/
    /******/ 	// define getter function for harmony exports
    /******/ 	__webpack_require__.d = function(exports, name, getter) {
        /******/ 		if(!__webpack_require__.o(exports, name)) {
            /******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
            /******/ 		}
        /******/ 	};
    /******/
    /******/ 	// define __esModule on exports
    /******/ 	__webpack_require__.r = function(exports) {
        /******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
            /******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
            /******/ 		}
        /******/ 		Object.defineProperty(exports, '__esModule', { value: true });
        /******/ 	};
    /******/
    /******/ 	// create a fake namespace object
    /******/ 	// mode & 1: value is a module id, require it
    /******/ 	// mode & 2: merge all properties of value into the ns
    /******/ 	// mode & 4: return value when already ns object
    /******/ 	// mode & 8|1: behave like require
    /******/ 	__webpack_require__.t = function(value, mode) {
        /******/ 		if(mode & 1) value = __webpack_require__(value);
        /******/ 		if(mode & 8) return value;
        /******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
        /******/ 		var ns = Object.create(null);
        /******/ 		__webpack_require__.r(ns);
        /******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
        /******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
        /******/ 		return ns;
        /******/ 	};
    /******/
    /******/ 	// getDefaultExport function for compatibility with non-harmony modules
    /******/ 	__webpack_require__.n = function(module) {
        /******/ 		var getter = module && module.__esModule ?
            /******/ 			function getDefault() { return module['default']; } :
            /******/ 			function getModuleExports() { return module; };
        /******/ 		__webpack_require__.d(getter, 'a', getter);
        /******/ 		return getter;
        /******/ 	};
    /******/
    /******/ 	// Object.prototype.hasOwnProperty.call
    /******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
    /******/
    /******/ 	// __webpack_public_path__
    /******/ 	__webpack_require__.p = "";
    /******/
    /******/
    /******/ 	// Load entry module and return exports
    /******/ 	return __webpack_require__(__webpack_require__.s = 11);
    /******/ })
/************************************************************************/
/******/ ([
    /* 0 */,
    /* 1 */,
    /* 2 */
    /***/ (function(module, exports) {

        module.exports = function (callback) {
            if (document.readyState === 'complete' || document.readyState === 'interactive') {
                // Already ready or interactive, execute callback
                callback.call();
            } else if (document.attachEvent) {
                // Old browsers
                document.attachEvent('onreadystatechange', function () {
                    if (document.readyState === 'interactive') callback.call();
                });
            } else if (document.addEventListener) {
                // Modern browsers
                document.addEventListener('DOMContentLoaded', callback);
            }
        };

        /***/ }),
    /* 3 */,
    /* 4 */
    /***/ (function(module, exports, __webpack_require__) {

        /* WEBPACK VAR INJECTION */(function(global) {var win;

            if (typeof window !== "undefined") {
                win = window;
            } else if (typeof global !== "undefined") {
                win = global;
            } else if (typeof self !== "undefined") {
                win = self;
            } else {
                win = {};
            }

            module.exports = win;
            /* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(5)))

        /***/ }),
    /* 5 */
    /***/ (function(module, exports) {

        function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

        var g; // This works in non-strict mode

        g = function () {
            return this;
        }();

        try {
            // This works if eval is allowed (see CSP)
            g = g || new Function("return this")();
        } catch (e) {
            // This works if the window reference is available
            if ((typeof window === "undefined" ? "undefined" : _typeof(window)) === "object") g = window;
        } // g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}


        module.exports = g;

        /***/ }),
    /* 6 */,
    /* 7 */,
    /* 8 */,
    /* 9 */,
    /* 10 */,
    /* 11 */
    /***/ (function(module, exports, __webpack_require__) {

        module.exports = __webpack_require__(12);


        /***/ }),
    /* 12 */
    /***/ (function(module, __webpack_exports__, __webpack_require__) {

        "use strict";
        __webpack_require__.r(__webpack_exports__);
        /* harmony import */ var lite_ready__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
        /* harmony import */ var lite_ready__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lite_ready__WEBPACK_IMPORTED_MODULE_0__);
        /* harmony import */ var global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(4);
        /* harmony import */ var global__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(global__WEBPACK_IMPORTED_MODULE_1__);
        /* harmony import */ var _jarallax_esm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13);
        function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }



        // no conflict

        var oldPlugin = global__WEBPACK_IMPORTED_MODULE_1__["window"].jarallax;
        global__WEBPACK_IMPORTED_MODULE_1__["window"].jarallax = _jarallax_esm__WEBPACK_IMPORTED_MODULE_2__["default"];

        global__WEBPACK_IMPORTED_MODULE_1__["window"].jarallax.noConflict = function () {
            global__WEBPACK_IMPORTED_MODULE_1__["window"].jarallax = oldPlugin;
            return this;
        }; // jQuery support


        if (typeof global__WEBPACK_IMPORTED_MODULE_1__["jQuery"] !== 'undefined') {
            var jQueryPlugin = function jQueryPlugin() {
                var args = arguments || [];
                Array.prototype.unshift.call(args, this);
                var res = _jarallax_esm__WEBPACK_IMPORTED_MODULE_2__["default"].apply(global__WEBPACK_IMPORTED_MODULE_1__["window"], args);
                return _typeof(res) !== 'object' ? res : this;
            };

            jQueryPlugin.constructor = _jarallax_esm__WEBPACK_IMPORTED_MODULE_2__["default"].constructor; // no conflict

            var oldJqPlugin = global__WEBPACK_IMPORTED_MODULE_1__["jQuery"].fn.jarallax;
            global__WEBPACK_IMPORTED_MODULE_1__["jQuery"].fn.jarallax = jQueryPlugin;

            global__WEBPACK_IMPORTED_MODULE_1__["jQuery"].fn.jarallax.noConflict = function () {
                global__WEBPACK_IMPORTED_MODULE_1__["jQuery"].fn.jarallax = oldJqPlugin;
                return this;
            };
        } // data-jarallax initialization


        lite_ready__WEBPACK_IMPORTED_MODULE_0___default()(function () {
            Object(_jarallax_esm__WEBPACK_IMPORTED_MODULE_2__["default"])(document.querySelectorAll('[data-jarallax]'));
        });

        /***/ }),
    /* 13 */
    /***/ (function(module, __webpack_exports__, __webpack_require__) {

        "use strict";
        __webpack_require__.r(__webpack_exports__);
        /* harmony import */ var lite_ready__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2);
        /* harmony import */ var lite_ready__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lite_ready__WEBPACK_IMPORTED_MODULE_0__);
        /* harmony import */ var rafl__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(14);
        /* harmony import */ var rafl__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(rafl__WEBPACK_IMPORTED_MODULE_1__);
        /* harmony import */ var global__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(4);
        /* harmony import */ var global__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(global__WEBPACK_IMPORTED_MODULE_2__);
        function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

        function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

        function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

        function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

        function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

        function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

        function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

        function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }




        var isIE = navigator.userAgent.indexOf('MSIE ') > -1 || navigator.userAgent.indexOf('Trident/') > -1 || navigator.userAgent.indexOf('Edge/') > -1;
        var isMobile = /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);

        var supportTransform = function () {
            var prefixes = 'transform WebkitTransform MozTransform'.split(' ');
            var div = document.createElement('div');

            for (var i = 0; i < prefixes.length; i++) {
                if (div && div.style[prefixes[i]] !== undefined) {
                    return prefixes[i];
                }
            }

            return false;
        }();

        var $deviceHelper;
        /**
         * The most popular mobile browsers changes height after page scroll and this generates image jumping.
         * We can fix it using this workaround with vh units.
         */

        function getDeviceHeight() {
            if (!$deviceHelper && document.body) {
                $deviceHelper = document.createElement('div');
                $deviceHelper.style.cssText = 'position: fixed; top: -9999px; left: 0; height: 100vh; width: 0;';
                document.body.appendChild($deviceHelper);
            }

            return ($deviceHelper ? $deviceHelper.clientHeight : 0) || global__WEBPACK_IMPORTED_MODULE_2__["window"].innerHeight || document.documentElement.clientHeight;
        } // Window height data


        var wndH;

        function updateWndVars() {
            if (isMobile) {
                wndH = getDeviceHeight();
            } else {
                wndH = global__WEBPACK_IMPORTED_MODULE_2__["window"].innerHeight || document.documentElement.clientHeight;
            }
        }

        updateWndVars();
        global__WEBPACK_IMPORTED_MODULE_2__["window"].addEventListener('resize', updateWndVars);
        global__WEBPACK_IMPORTED_MODULE_2__["window"].addEventListener('orientationchange', updateWndVars);
        global__WEBPACK_IMPORTED_MODULE_2__["window"].addEventListener('load', updateWndVars);
        lite_ready__WEBPACK_IMPORTED_MODULE_0___default()(function () {
            updateWndVars({
                type: 'dom-loaded'
            });
        }); // list with all jarallax instances
// need to render all in one scroll/resize event

        var jarallaxList = []; // get all parents of the element.

        function getParents(elem) {
            var parents = [];

            while (elem.parentElement !== null) {
                elem = elem.parentElement;

                if (elem.nodeType === 1) {
                    parents.push(elem);
                }
            }

            return parents;
        }

        function updateParallax() {
            if (!jarallaxList.length) {
                return;
            }

            jarallaxList.forEach(function (data, k) {
                var instance = data.instance,
                    oldData = data.oldData;
                var clientRect = instance.$item.getBoundingClientRect();
                var newData = {
                    width: clientRect.width,
                    height: clientRect.height,
                    top: clientRect.top,
                    bottom: clientRect.bottom,
                    wndW: global__WEBPACK_IMPORTED_MODULE_2__["window"].innerWidth,
                    wndH: wndH
                };
                var isResized = !oldData || oldData.wndW !== newData.wndW || oldData.wndH !== newData.wndH || oldData.width !== newData.width || oldData.height !== newData.height;
                var isScrolled = isResized || !oldData || oldData.top !== newData.top || oldData.bottom !== newData.bottom;
                jarallaxList[k].oldData = newData;

                if (isResized) {
                    instance.onResize();
                }

                if (isScrolled) {
                    instance.onScroll();
                }
            });
            rafl__WEBPACK_IMPORTED_MODULE_1___default()(updateParallax);
        }

        var instanceID = 0; // Jarallax class

        var Jarallax =
            /*#__PURE__*/
            function () {
                function Jarallax(item, userOptions) {
                    _classCallCheck(this, Jarallax);

                    var self = this;
                    self.instanceID = instanceID++;
                    self.$item = item;
                    self.defaults = {
                        type: 'scroll',
                        // type of parallax: scroll, scale, opacity, scale-opacity, scroll-opacity
                        speed: 0.5,
                        // supported value from -1 to 2
                        imgSrc: null,
                        imgElement: '.jarallax-img',
                        imgSize: 'cover',
                        imgPosition: '50% 50%',
                        imgRepeat: 'no-repeat',
                        // supported only for background, not for <img> tag
                        keepImg: false,
                        // keep <img> tag in it's default place
                        elementInViewport: null,
                        zIndex: -100,
                        disableParallax: false,
                        disableVideo: false,
                        // video
                        videoSrc: null,
                        videoStartTime: 0,
                        videoEndTime: 0,
                        videoVolume: 0,
                        videoLoop: true,
                        videoPlayOnlyVisible: true,
                        videoLazyLoading: true,
                        // events
                        onScroll: null,
                        // function(calculations) {}
                        onInit: null,
                        // function() {}
                        onDestroy: null,
                        // function() {}
                        onCoverImage: null // function() {}

                    }; // prepare data-options

                    var dataOptions = self.$item.dataset || {};
                    var pureDataOptions = {};
                    Object.keys(dataOptions).forEach(function (key) {
                        var loweCaseOption = key.substr(0, 1).toLowerCase() + key.substr(1);

                        if (loweCaseOption && typeof self.defaults[loweCaseOption] !== 'undefined') {
                            pureDataOptions[loweCaseOption] = dataOptions[key];
                        }
                    });
                    self.options = self.extend({}, self.defaults, pureDataOptions, userOptions);
                    self.pureOptions = self.extend({}, self.options); // prepare 'true' and 'false' strings to boolean

                    Object.keys(self.options).forEach(function (key) {
                        if (self.options[key] === 'true') {
                            self.options[key] = true;
                        } else if (self.options[key] === 'false') {
                            self.options[key] = false;
                        }
                    }); // fix speed option [-1.0, 2.0]

                    self.options.speed = Math.min(2, Math.max(-1, parseFloat(self.options.speed))); // prepare disableParallax callback

                    if (typeof self.options.disableParallax === 'string') {
                        self.options.disableParallax = new RegExp(self.options.disableParallax);
                    }

                    if (self.options.disableParallax instanceof RegExp) {
                        var disableParallaxRegexp = self.options.disableParallax;

                        self.options.disableParallax = function () {
                            return disableParallaxRegexp.test(navigator.userAgent);
                        };
                    }

                    if (typeof self.options.disableParallax !== 'function') {
                        self.options.disableParallax = function () {
                            return false;
                        };
                    } // prepare disableVideo callback


                    if (typeof self.options.disableVideo === 'string') {
                        self.options.disableVideo = new RegExp(self.options.disableVideo);
                    }

                    if (self.options.disableVideo instanceof RegExp) {
                        var disableVideoRegexp = self.options.disableVideo;

                        self.options.disableVideo = function () {
                            return disableVideoRegexp.test(navigator.userAgent);
                        };
                    }

                    if (typeof self.options.disableVideo !== 'function') {
                        self.options.disableVideo = function () {
                            return false;
                        };
                    } // custom element to check if parallax in viewport


                    var elementInVP = self.options.elementInViewport; // get first item from array

                    if (elementInVP && _typeof(elementInVP) === 'object' && typeof elementInVP.length !== 'undefined') {
                        var _elementInVP = elementInVP;

                        var _elementInVP2 = _slicedToArray(_elementInVP, 1);

                        elementInVP = _elementInVP2[0];
                    } // check if dom element


                    if (!(elementInVP instanceof Element)) {
                        elementInVP = null;
                    }

                    self.options.elementInViewport = elementInVP;
                    self.image = {
                        src: self.options.imgSrc || null,
                        $container: null,
                        useImgTag: false,
                        // position fixed is needed for the most of browsers because absolute position have glitches
                        // on MacOS with smooth scroll there is a huge lags with absolute position - https://github.com/nk-o/jarallax/issues/75
                        // on mobile devices better scrolled with absolute position
                        position: /iPad|iPhone|iPod|Android/.test(navigator.userAgent) ? 'absolute' : 'fixed'
                    };

                    if (self.initImg() && self.canInitParallax()) {
                        self.init();
                    }
                } // add styles to element


                _createClass(Jarallax, [{
                    key: "css",
                    value: function css(el, styles) {
                        if (typeof styles === 'string') {
                            return global__WEBPACK_IMPORTED_MODULE_2__["window"].getComputedStyle(el).getPropertyValue(styles);
                        } // add transform property with vendor prefix


                        if (styles.transform && supportTransform) {
                            styles[supportTransform] = styles.transform;
                        }

                        Object.keys(styles).forEach(function (key) {
                            el.style[key] = styles[key];
                        });
                        return el;
                    } // Extend like jQuery.extend

                }, {
                    key: "extend",
                    value: function extend(out) {
                        var _arguments = arguments;
                        out = out || {};
                        Object.keys(arguments).forEach(function (i) {
                            if (!_arguments[i]) {
                                return;
                            }

                            Object.keys(_arguments[i]).forEach(function (key) {
                                out[key] = _arguments[i][key];
                            });
                        });
                        return out;
                    } // get window size and scroll position. Useful for extensions

                }, {
                    key: "getWindowData",
                    value: function getWindowData() {
                        return {
                            width: global__WEBPACK_IMPORTED_MODULE_2__["window"].innerWidth || document.documentElement.clientWidth,
                            height: wndH,
                            y: document.documentElement.scrollTop
                        };
                    } // Jarallax functions

                }, {
                    key: "initImg",
                    value: function initImg() {
                        var self = this; // find image element

                        var $imgElement = self.options.imgElement;

                        if ($imgElement && typeof $imgElement === 'string') {
                            $imgElement = self.$item.querySelector($imgElement);
                        } // check if dom element


                        if (!($imgElement instanceof Element)) {
                            if (self.options.imgSrc) {
                                $imgElement = new Image();
                                $imgElement.src = self.options.imgSrc;
                            } else {
                                $imgElement = null;
                            }
                        }

                        if ($imgElement) {
                            if (self.options.keepImg) {
                                self.image.$item = $imgElement.cloneNode(true);
                            } else {
                                self.image.$item = $imgElement;
                                self.image.$itemParent = $imgElement.parentNode;
                            }

                            self.image.useImgTag = true;
                        } // true if there is img tag


                        if (self.image.$item) {
                            return true;
                        } // get image src


                        if (self.image.src === null) {
                            self.image.src = 'data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7';
                            self.image.bgImage = self.css(self.$item, 'background-image');
                        }

                        return !(!self.image.bgImage || self.image.bgImage === 'none');
                    }
                }, {
                    key: "canInitParallax",
                    value: function canInitParallax() {
                        return supportTransform && !this.options.disableParallax();
                    }
                }, {
                    key: "init",
                    value: function init() {
                        var self = this;
                        var containerStyles = {
                            position: 'absolute',
                            top: 0,
                            left: 0,
                            width: '100%',
                            height: '100%',
                            overflow: 'hidden',
                            pointerEvents: 'none'
                        };
                        var imageStyles = {};

                        if (!self.options.keepImg) {
                            // save default user styles
                            var curStyle = self.$item.getAttribute('style');

                            if (curStyle) {
                                self.$item.setAttribute('data-jarallax-original-styles', curStyle);
                            }

                            if (self.image.useImgTag) {
                                var curImgStyle = self.image.$item.getAttribute('style');

                                if (curImgStyle) {
                                    self.image.$item.setAttribute('data-jarallax-original-styles', curImgStyle);
                                }
                            }
                        } // set relative position and z-index to the parent


                        if (self.css(self.$item, 'position') === 'static') {
                            self.css(self.$item, {
                                position: 'relative'
                            });
                        }

                        if (self.css(self.$item, 'z-index') === 'auto') {
                            self.css(self.$item, {
                                zIndex: 0
                            });
                        } // container for parallax image


                        self.image.$container = document.createElement('div');
                        self.css(self.image.$container, containerStyles);
                        self.css(self.image.$container, {
                            'z-index': self.options.zIndex
                        }); // fix for IE https://github.com/nk-o/jarallax/issues/110

                        if (isIE) {
                            self.css(self.image.$container, {
                                opacity: 0.9999
                            });
                        }

                        self.image.$container.setAttribute('id', "jarallax-container-".concat(self.instanceID));
                        self.$item.appendChild(self.image.$container); // use img tag

                        if (self.image.useImgTag) {
                            imageStyles = self.extend({
                                'object-fit': self.options.imgSize,
                                'object-position': self.options.imgPosition,
                                // support for plugin https://github.com/bfred-it/object-fit-images
                                'font-family': "object-fit: ".concat(self.options.imgSize, "; object-position: ").concat(self.options.imgPosition, ";"),
                                'max-width': 'none'
                            }, containerStyles, imageStyles); // use div with background image
                        } else {
                            self.image.$item = document.createElement('div');

                            if (self.image.src) {
                                imageStyles = self.extend({
                                    'background-position': self.options.imgPosition,
                                    'background-size': self.options.imgSize,
                                    'background-repeat': self.options.imgRepeat,
                                    'background-image': self.image.bgImage || "url(\"".concat(self.image.src, "\")")
                                }, containerStyles, imageStyles);
                            }
                        }

                        if (self.options.type === 'opacity' || self.options.type === 'scale' || self.options.type === 'scale-opacity' || self.options.speed === 1) {
                            self.image.position = 'absolute';
                        } // 1. Check if one of parents have transform style (without this check, scroll transform will be inverted if used parallax with position fixed)
                        //    discussion - https://github.com/nk-o/jarallax/issues/9
                        // 2. Check if parents have overflow scroll


                        if (self.image.position === 'fixed') {
                            var $parents = getParents(self.$item).filter(function (el) {
                                var styles = global__WEBPACK_IMPORTED_MODULE_2__["window"].getComputedStyle(el);
                                var parentTransform = styles['-webkit-transform'] || styles['-moz-transform'] || styles.transform;
                                var overflowRegex = /(auto|scroll)/;
                                return parentTransform && parentTransform !== 'none' || overflowRegex.test(styles.overflow + styles['overflow-y'] + styles['overflow-x']);
                            });
                            self.image.position = $parents.length ? 'absolute' : 'fixed';
                        } // add position to parallax block


                        imageStyles.position = self.image.position; // insert parallax image

                        self.css(self.image.$item, imageStyles);
                        self.image.$container.appendChild(self.image.$item); // set initial position and size

                        self.onResize();
                        self.onScroll(true); // call onInit event

                        if (self.options.onInit) {
                            self.options.onInit.call(self);
                        } // remove default user background


                        if (self.css(self.$item, 'background-image') !== 'none') {
                            self.css(self.$item, {
                                'background-image': 'none'
                            });
                        }

                        self.addToParallaxList();
                    } // add to parallax instances list

                }, {
                    key: "addToParallaxList",
                    value: function addToParallaxList() {
                        jarallaxList.push({
                            instance: this
                        });

                        if (jarallaxList.length === 1) {
                            updateParallax();
                        }
                    } // remove from parallax instances list

                }, {
                    key: "removeFromParallaxList",
                    value: function removeFromParallaxList() {
                        var self = this;
                        jarallaxList.forEach(function (data, key) {
                            if (data.instance.instanceID === self.instanceID) {
                                jarallaxList.splice(key, 1);
                            }
                        });
                    }
                }, {
                    key: "destroy",
                    value: function destroy() {
                        var self = this;
                        self.removeFromParallaxList(); // return styles on container as before jarallax init

                        var originalStylesTag = self.$item.getAttribute('data-jarallax-original-styles');
                        self.$item.removeAttribute('data-jarallax-original-styles'); // null occurs if there is no style tag before jarallax init

                        if (!originalStylesTag) {
                            self.$item.removeAttribute('style');
                        } else {
                            self.$item.setAttribute('style', originalStylesTag);
                        }

                        if (self.image.useImgTag) {
                            // return styles on img tag as before jarallax init
                            var originalStylesImgTag = self.image.$item.getAttribute('data-jarallax-original-styles');
                            self.image.$item.removeAttribute('data-jarallax-original-styles'); // null occurs if there is no style tag before jarallax init

                            if (!originalStylesImgTag) {
                                self.image.$item.removeAttribute('style');
                            } else {
                                self.image.$item.setAttribute('style', originalStylesTag);
                            } // move img tag to its default position


                            if (self.image.$itemParent) {
                                self.image.$itemParent.appendChild(self.image.$item);
                            }
                        } // remove additional dom elements


                        if (self.$clipStyles) {
                            self.$clipStyles.parentNode.removeChild(self.$clipStyles);
                        }

                        if (self.image.$container) {
                            self.image.$container.parentNode.removeChild(self.image.$container);
                        } // call onDestroy event


                        if (self.options.onDestroy) {
                            self.options.onDestroy.call(self);
                        } // delete jarallax from item


                        delete self.$item.jarallax;
                    } // it will remove some image overlapping
                    // overlapping occur due to an image position fixed inside absolute position element

                }, {
                    key: "clipContainer",
                    value: function clipContainer() {
                        // needed only when background in fixed position
                        if (this.image.position !== 'fixed') {
                            return;
                        }

                        var self = this;
                        var rect = self.image.$container.getBoundingClientRect();
                        var width = rect.width,
                            height = rect.height;

                        if (!self.$clipStyles) {
                            self.$clipStyles = document.createElement('style');
                            self.$clipStyles.setAttribute('type', 'text/css');
                            self.$clipStyles.setAttribute('id', "jarallax-clip-".concat(self.instanceID));
                            var head = document.head || document.getElementsByTagName('head')[0];
                            head.appendChild(self.$clipStyles);
                        }

                        var styles = "#jarallax-container-".concat(self.instanceID, " {\n           clip: rect(0 ").concat(width, "px ").concat(height, "px 0);\n           clip: rect(0, ").concat(width, "px, ").concat(height, "px, 0);\n        }"); // add clip styles inline (this method need for support IE8 and less browsers)

                        if (self.$clipStyles.styleSheet) {
                            self.$clipStyles.styleSheet.cssText = styles;
                        } else {
                            self.$clipStyles.innerHTML = styles;
                        }
                    }
                }, {
                    key: "coverImage",
                    value: function coverImage() {
                        var self = this;
                        var rect = self.image.$container.getBoundingClientRect();
                        var contH = rect.height;
                        var speed = self.options.speed;
                        var isScroll = self.options.type === 'scroll' || self.options.type === 'scroll-opacity';
                        var scrollDist = 0;
                        var resultH = contH;
                        var resultMT = 0; // scroll parallax

                        if (isScroll) {
                            // scroll distance and height for image
                            if (speed < 0) {
                                scrollDist = speed * Math.max(contH, wndH);

                                if (wndH < contH) {
                                    scrollDist -= speed * (contH - wndH);
                                }
                            } else {
                                scrollDist = speed * (contH + wndH);
                            } // size for scroll parallax


                            if (speed > 1) {
                                resultH = Math.abs(scrollDist - wndH);
                            } else if (speed < 0) {
                                resultH = scrollDist / speed + Math.abs(scrollDist);
                            } else {
                                resultH += (wndH - contH) * (1 - speed);
                            }

                            scrollDist /= 2;
                        } // store scroll distance


                        self.parallaxScrollDistance = scrollDist; // vertical center

                        if (isScroll) {
                            resultMT = (wndH - resultH) / 2;
                        } else {
                            resultMT = (contH - resultH) / 2;
                        } // apply result to item


                        self.css(self.image.$item, {
                            height: "".concat(resultH, "px"),
                            marginTop: "".concat(resultMT, "px"),
                            left: self.image.position === 'fixed' ? "".concat(rect.left, "px") : '0',
                            width: "".concat(rect.width, "px")
                        }); // call onCoverImage event

                        if (self.options.onCoverImage) {
                            self.options.onCoverImage.call(self);
                        } // return some useful data. Used in the video cover function


                        return {
                            image: {
                                height: resultH,
                                marginTop: resultMT
                            },
                            container: rect
                        };
                    }
                }, {
                    key: "isVisible",
                    value: function isVisible() {
                        return this.isElementInViewport || false;
                    }
                }, {
                    key: "onScroll",
                    value: function onScroll(force) {
                        var self = this;
                        var rect = self.$item.getBoundingClientRect();
                        var contT = rect.top;
                        var contH = rect.height;
                        var styles = {}; // check if in viewport

                        var viewportRect = rect;

                        if (self.options.elementInViewport) {
                            viewportRect = self.options.elementInViewport.getBoundingClientRect();
                        }

                        self.isElementInViewport = viewportRect.bottom >= 0 && viewportRect.right >= 0 && viewportRect.top <= wndH && viewportRect.left <= global__WEBPACK_IMPORTED_MODULE_2__["window"].innerWidth; // stop calculations if item is not in viewport

                        if (force ? false : !self.isElementInViewport) {
                            return;
                        } // calculate parallax helping variables


                        var beforeTop = Math.max(0, contT);
                        var beforeTopEnd = Math.max(0, contH + contT);
                        var afterTop = Math.max(0, -contT);
                        var beforeBottom = Math.max(0, contT + contH - wndH);
                        var beforeBottomEnd = Math.max(0, contH - (contT + contH - wndH));
                        var afterBottom = Math.max(0, -contT + wndH - contH);
                        var fromViewportCenter = 1 - 2 * (wndH - contT) / (wndH + contH); // calculate on how percent of section is visible

                        var visiblePercent = 1;

                        if (contH < wndH) {
                            visiblePercent = 1 - (afterTop || beforeBottom) / contH;
                        } else if (beforeTopEnd <= wndH) {
                            visiblePercent = beforeTopEnd / wndH;
                        } else if (beforeBottomEnd <= wndH) {
                            visiblePercent = beforeBottomEnd / wndH;
                        } // opacity


                        if (self.options.type === 'opacity' || self.options.type === 'scale-opacity' || self.options.type === 'scroll-opacity') {
                            styles.transform = 'translate3d(0,0,0)';
                            styles.opacity = visiblePercent;
                        } // scale


                        if (self.options.type === 'scale' || self.options.type === 'scale-opacity') {
                            var scale = 1;

                            if (self.options.speed < 0) {
                                scale -= self.options.speed * visiblePercent;
                            } else {
                                scale += self.options.speed * (1 - visiblePercent);
                            }

                            styles.transform = "scale(".concat(scale, ") translate3d(0,0,0)");
                        } // scroll


                        if (self.options.type === 'scroll' || self.options.type === 'scroll-opacity') {
                            var positionY = self.parallaxScrollDistance * fromViewportCenter; // fix if parallax block in absolute position

                            if (self.image.position === 'absolute') {
                                positionY -= contT;
                            }

                            styles.transform = "translate3d(0,".concat(positionY, "px,0)");
                        }

                        self.css(self.image.$item, styles); // call onScroll event

                        if (self.options.onScroll) {
                            self.options.onScroll.call(self, {
                                section: rect,
                                beforeTop: beforeTop,
                                beforeTopEnd: beforeTopEnd,
                                afterTop: afterTop,
                                beforeBottom: beforeBottom,
                                beforeBottomEnd: beforeBottomEnd,
                                afterBottom: afterBottom,
                                visiblePercent: visiblePercent,
                                fromViewportCenter: fromViewportCenter
                            });
                        }
                    }
                }, {
                    key: "onResize",
                    value: function onResize() {
                        this.coverImage();
                        this.clipContainer();
                    }
                }]);

                return Jarallax;
            }(); // global definition


        var plugin = function plugin(items) {
            // check for dom element
            // thanks: http://stackoverflow.com/questions/384286/javascript-isdom-how-do-you-check-if-a-javascript-object-is-a-dom-object
            if ((typeof HTMLElement === "undefined" ? "undefined" : _typeof(HTMLElement)) === 'object' ? items instanceof HTMLElement : items && _typeof(items) === 'object' && items !== null && items.nodeType === 1 && typeof items.nodeName === 'string') {
                items = [items];
            }

            var options = arguments[1];
            var args = Array.prototype.slice.call(arguments, 2);
            var len = items.length;
            var k = 0;
            var ret;

            for (k; k < len; k++) {
                if (_typeof(options) === 'object' || typeof options === 'undefined') {
                    if (!items[k].jarallax) {
                        items[k].jarallax = new Jarallax(items[k], options);
                    }
                } else if (items[k].jarallax) {
                    // eslint-disable-next-line prefer-spread
                    ret = items[k].jarallax[options].apply(items[k].jarallax, args);
                }

                if (typeof ret !== 'undefined') {
                    return ret;
                }
            }

            return items;
        };

        plugin.constructor = Jarallax;
        /* harmony default export */ __webpack_exports__["default"] = (plugin);

        /***/ }),
    /* 14 */
    /***/ (function(module, exports, __webpack_require__) {

        var global = __webpack_require__(15);
        /**
         * `requestAnimationFrame()`
         */


        var request = global.requestAnimationFrame || global.webkitRequestAnimationFrame || global.mozRequestAnimationFrame || fallback;
        var prev = +new Date();

        function fallback(fn) {
            var curr = +new Date();
            var ms = Math.max(0, 16 - (curr - prev));
            var req = setTimeout(fn, ms);
            return prev = curr, req;
        }
        /**
         * `cancelAnimationFrame()`
         */


        var cancel = global.cancelAnimationFrame || global.webkitCancelAnimationFrame || global.mozCancelAnimationFrame || clearTimeout;

        if (Function.prototype.bind) {
            request = request.bind(global);
            cancel = cancel.bind(global);
        }

        exports = module.exports = request;
        exports.cancel = cancel;

        /***/ }),
    /* 15 */
    /***/ (function(module, exports, __webpack_require__) {

        /* WEBPACK VAR INJECTION */(function(global) {var win;

            if (typeof window !== "undefined") {
                win = window;
            } else if (typeof global !== "undefined") {
                win = global;
            } else if (typeof self !== "undefined") {
                win = self;
            } else {
                win = {};
            }

            module.exports = win;
            /* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(5)))

        /***/ })
    /******/ ]);