<?php

namespace Magento\OutOfProcessTaxManagement\Model\Data;

use Magento\Framework\DataObject;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemTaxInterface;

class OopQuoteItemTax extends DataObject implements OopQuoteItemTaxInterface
{
    /**
     * @return float
     */
    public function getRate(): float
    {
        return (float)$this->getData(self::FIELD_RATE);
    }

    /**
     * @param float $rate
     * @return $this
     */
    public function setRate(float $rate): self
    {
        $this->setData(self::FIELD_RATE, $rate);
        return $this;
    }

    /**
     * @return float
     */
    public function getAmount(): float
    {
        return (float)$this->getData(self::FIELD_AMOUNT);
    }

    /**
     * @param float $amount
     * @return $this
     */
    public function setAmount(float $amount): self
    {
        $this->setData(self::FIELD_AMOUNT, $amount);
        return $this;
    }

    /**
     * @return float
     */
    public function getDiscountCompensationAmount(): float
    {
        return (float)$this->getData(self::FIELD_DISCOUNT_COMPENSATION_AMOUNT);
    }

    /**
     * @param float $discountCompensationAmount
     * @return $this
     */
    public function setDiscountCompensationAmount(float $discountCompensationAmount): self
    {
        $this->setData(self::FIELD_DISCOUNT_COMPENSATION_AMOUNT, $discountCompensationAmount);
        return $this;
    }
}
