<?php

declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model\Data;

use Magento\Framework\DataObject;
use Magento\OutOfProcessTaxManagement\Api\Data\OopAddressInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopShippingInterface;

class OopQuote extends DataObject implements OopQuoteInterface
{
    /**
     * @return int|null
     */
    public function getQuoteId(): ?int
    {
        $quoteId = $this->getData(self::FIELD_QUOTE_ID);
        return $quoteId ? (int)$quoteId : null;
    }

    /**
     * @param int $quoteId
     * @return $this
     */
    public function setQuoteId(int $quoteId): self
    {
        $this->setData(self::FIELD_QUOTE_ID, $quoteId);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCustomerTaxClass(): ?string
    {
        return (string)$this->getData(self::FIELD_CUSTOMER_TAX_CLASS);
    }

    /**
     * @param string $taxClassName
     * @return $this
     */
    public function setCustomerTaxClass(string $taxClassName): self
    {
        $this->setData(self::FIELD_CUSTOMER_TAX_CLASS, $taxClassName);
        return $this;
    }

    /**
     * @return OopQuoteItemInterface[]
     */
    public function getItems(): array
    {
        $quoteItems = $this->getData(self::FIELD_ITEMS);
        if (is_array($quoteItems)) {
            return $quoteItems;
        }
        return [];
    }

    /**
     * @param OopQuoteItemInterface[] $items
     * @return OopQuoteInterface
     */
    public function setItems(array $items): self
    {
        $this->setData(self::FIELD_ITEMS, $items);
        return $this;
    }

    /**
     * @return OopAddressInterface
     */
    public function getShipFromAddress(): OopAddressInterface
    {
        return $this->getData(self::FIELD_SHIP_FROM_ADDRESS);
    }

    /**
     * @param OopAddressInterface $shipFromAddress
     * @return OopQuoteInterface
     */
    public function setShipFromAddress(OopAddressInterface $shipFromAddress): OopQuoteInterface
    {
        $this->setData(self::FIELD_SHIP_FROM_ADDRESS, $shipFromAddress);
        return $this;
    }

    /**
     * @return OopAddressInterface
     */
    public function getShipToAddress(): OopAddressInterface
    {
        return $this->getData(self::FIELD_SHIP_TO_ADDRESS);
    }

    /**
     * @param OopAddressInterface $shipToAddress
     * @return OopQuoteInterface
     */
    public function setShipToAddress(OopAddressInterface $shipToAddress): OopQuoteInterface
    {
        $this->setData(self::FIELD_SHIP_TO_ADDRESS, $shipToAddress);
        return $this;
    }

    /**
     * @return OopAddressInterface
     */
    public function getBillingAddress(): OopAddressInterface
    {
        return $this->getData(self::FIELD_BILLING_ADDRESS);
    }

    /**
     * @param OopAddressInterface $billingAddress
     * @return OopQuoteInterface
     */
    public function setBillingAddress(OopAddressInterface $billingAddress): OopQuoteInterface
    {
        $this->setData(self::FIELD_BILLING_ADDRESS, $billingAddress);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getShipping(): OopShippingInterface
    {
        return $this->getData(self::FIELD_SHIPPING);
    }

    /**
     * @inheritDoc
     */
    public function setShipping(OopShippingInterface $shipping): self
    {
        $this->setData(self::FIELD_SHIPPING, $shipping);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getCustomAttributes(): array
    {
        return $this->getData(self::FIELD_CUSTOM_ATTRIBUTES) ?? [];
    }

    /**
     * @inheritDoc
     */
    public function setCustomAttributes(array $customAttributes): self
    {
        $this->setData(self::FIELD_CUSTOM_ATTRIBUTES, $customAttributes);
        return $this;
    }
}
