<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model;

use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemTaxBreakdownInterfaceFactory;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemTaxInterfaceFactory;
use Magento\OutOfProcessTaxManagement\Api\OopTaxCollectionInterface;
use Psr\Log\LoggerInterface;

class OopTaxCollection implements OopTaxCollectionInterface
{
    public function __construct(
        private readonly OopQuoteItemTaxInterfaceFactory          $taxFactory,
        private readonly OopQuoteItemTaxBreakdownInterfaceFactory $taxBreakdownFactory,
        private readonly LoggerInterface                          $logger
    ) {
    }

    /**
     * @param OopQuoteInterface $oopQuote
     * @return OopQuoteInterface
     */
    public function collectTaxes(OopQuoteInterface $oopQuote): OopQuoteInterface
    {
        // expected final implementation:
        return $oopQuote;

        // placeholder code representing expectations for runtime implementation

        // taxes to apply to everything
        $taxesToApply = [
            'state_tax' => 2.25,
            'county_tax' => 6.3
        ];

        foreach ($oopQuote->getItems() as $quoteItem) {
            $rowPrice = $quoteItem->getUnitPrice() * $quoteItem->getQuantity();
            $rowTaxes = 0;
            $taxBreakdown = [];
            foreach ($taxesToApply as $code => $rate) {
                $taxAmount = $rate / 100 * $rowPrice;
                $rowTaxes += $taxAmount;
                $taxBreakdown[] = $this->taxBreakdownFactory->create()
                    ->setCode($code)
                    ->setTitle(ucfirst(str_replace('_', ' ', $code)))
                    ->setRate($rate)
                    ->setAmount(round($taxAmount, 2))
                    ->setTaxRateKey(sprintf("%s-%0.2f", $code, $rate));
            }
            $rowRate = round($rowTaxes / $rowPrice * 100, 2);
            $rowTaxes = round($rowTaxes, 2);
            $quoteItem->setTax(
                $this->taxFactory->create()
                    ->setAmount($rowTaxes)
                    ->setRate($rowRate)
            );
            $quoteItem->setTaxBreakdown($taxBreakdown);
        }

        return $oopQuote;
    }
}
