<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model;

use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;
use Magento\OutOfProcessTaxManagement\Api\Data\OutOfProcessTaxIntegrationInterface;
use Magento\OutOfProcessTaxManagement\Model\Helper\StoreHelper;
use Magento\OutOfProcessTaxManagement\Model\ResourceModel\OutOfProcessTaxIntegration as ResourceModel;

class OutOfProcessTaxIntegration extends AbstractModel implements OutOfProcessTaxIntegrationInterface
{
    /**
     * @param StoreHelper $storeHelper
     * @param Context $context
     * @param Registry $registry
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        private readonly StoreHelper            $storeHelper,
        private readonly Context                $context,
        private readonly Registry               $registry,
        private readonly ?AbstractResource      $resource = null,
        private readonly ?AbstractDb            $resourceCollection = null,
        private readonly array                  $data = [],
    ) {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * @inheritDoc
     */
    protected function _construct(): void
    {
        $this->_init(ResourceModel::class);
    }

    /**
     * @inheritDoc
     */
    public function getCode(): string
    {
        return $this->getData(self::FIELD_CODE);
    }

    /**
     * @inheritDoc
     */
    public function setCode(string $code): self
    {
        $this->setData(self::FIELD_CODE, $code);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getTitle(): string
    {
        return $this->getData(self::FIELD_TITLE);
    }

    /**
     * @inheritDoc
     */
    public function setTitle(string $title): self
    {
        $this->setData(self::FIELD_TITLE, $title);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function isActive(): bool
    {
        return $this->getData(self::FIELD_ACTIVE) === '1';
    }

    /**
     * @inheritDoc
     */
    public function setActive(bool $active): self
    {
        $this->setData(self::FIELD_ACTIVE, $active ? '1' : '0');
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getStores(): array
    {
        $stores = $this->storeHelper->getById($this->getData(self::FIELD_STORE_IDS));
        return array_map(fn ($store) => $store->getCode(), $stores);
    }

    /**
     * @inheritDoc
     */
    public function setStores(array $stores): self
    {
        $stores = $this->storeHelper->getByCode($stores);
        $storeIds = array_map(fn ($store) => $store->getId(), $stores);

        return $this->setData(self::FIELD_STORE_IDS, $storeIds);
    }
}
