<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model\Data;

use Magento\Framework\DataObject;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemTaxInterface;

class OopQuoteItem extends DataObject implements OopQuoteItemInterface
{
    /**
     * @inheritDoc
     */
    public function getQuantity(): float
    {
        return (float)$this->getData(self::FIELD_QUANTITY);
    }

    /**
     * @inheritDoc
     */
    public function setQuantity(float $quantity): self
    {
        $this->setData(self::FIELD_QUANTITY, $quantity);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getCode(): string
    {
        return (string)$this->getData(self::FIELD_CODE);
    }

    /**
     * @inheritDoc
     */
    public function setCode(string $code): self
    {
        $this->setData(self::FIELD_CODE, $code);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getType(): string
    {
        return (string)$this->getData(self::FIELD_TYPE);
    }

    /**
     * @inheritDoc
     */
    public function setType(string $itemType): self
    {
        $this->setData(self::FIELD_TYPE, $itemType);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getTaxClass(): ?string
    {
        return $this->getData(self::FIELD_TAX_CLASS);
    }

    /**
     * @inheritDoc
     */
    public function setTaxClass(string $taxClass): self
    {
        $this->setData(self::FIELD_TAX_CLASS, $taxClass);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getUnitPrice(): float
    {
        return (float)$this->getData(self::FIELD_UNIT_PRICE);
    }

    /**
     * @inheritDoc
     */
    public function setUnitPrice(float $unitPrice): self
    {
        $this->setData(self::FIELD_UNIT_PRICE, $unitPrice);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getIsTaxIncluded(): bool
    {
        return (bool)$this->getData(self::FIELD_IS_TAX_INCLUDED);
    }

    /**
     * @inheritDoc
     */
    public function setIsTaxInclude(bool $isTaxIncluded): self
    {
        $this->setData(self::FIELD_IS_TAX_INCLUDED, $isTaxIncluded);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getDiscountAmount(): float
    {
        return (float)$this->getData(self::FIELD_DISCOUNT_AMOUNT);
    }

    /**
     * @inheritDoc
     */
    public function setDiscountAmount(float $discountAmount): self
    {
        $this->setData(self::FIELD_DISCOUNT_AMOUNT, $discountAmount);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getCustomAttributes(): array
    {
        return $this->getData(self::FIELD_CUSTOM_ATTRIBUTES) ?? [];
    }

    /**
     * @inheritDoc
     */
    public function setCustomAttributes(array $customAttributes): self
    {
        $this->setData(self::FIELD_CUSTOM_ATTRIBUTES, $customAttributes);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getSku(): ?string
    {
        return $this->getData(self::FIELD_SKU);
    }

    /**
     * @inheritDoc
     */
    public function setSku(string $sku): self
    {
        $this->setData(self::FIELD_SKU, $sku);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getName(): ?string
    {
        return $this->getData(self::FIELD_NAME);
    }

    /**
     * @inheritDoc
     */
    public function setName(string $name): self
    {
        $this->setData(self::FIELD_NAME, $name);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getTax(): ?OopQuoteItemTaxInterface
    {
        return $this->getData(self::FIELD_TAX);
    }

    /**
     * @param OopQuoteItemTaxInterface $tax
     * @return $this
     */
    public function setTax(OopQuoteItemTaxInterface $tax): self
    {
        $this->setData(self::FIELD_TAX, $tax);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getTaxBreakdown(): ?array
    {
        $quoteItemTaxBreakdown = $this->getData(self::FIELD_TAX_BREAKDOWN);
        if (is_array($quoteItemTaxBreakdown)) {
            return $quoteItemTaxBreakdown;
        }
        return [];
    }

    /**
     * @inheritDoc
     */
    public function setTaxBreakdown(array $taxBreakdown): self
    {
        $this->setData(self::FIELD_TAX_BREAKDOWN, $taxBreakdown);
        return $this;
    }
}
