<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Api;

use Magento\Framework\Exception\InvalidArgumentException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\OutOfProcessTaxManagement\Api\Data\OutOfProcessTaxIntegrationInterface;

interface OutOfProcessTaxIntegrationRepositoryInterface
{

    /**
     * Retrieve a tax integration by its code.
     *
     * @param string $code
     * @return \Magento\OutOfProcessTaxManagement\Api\Data\OutOfProcessTaxIntegrationInterface
     * @throws NoSuchEntityException If the tax integration does not exist.
     */
    public function getByCode(string $code): OutOfProcessTaxIntegrationInterface;

    /**
     * Retrieve a list of all tax integrations.
     *
     * @return \Magento\OutOfProcessTaxManagement\Api\Data\OutOfProcessTaxIntegrationInterface[]
     */
    public function getList(): array;

    /**
     * Creates or updates an out of process tax integrations.
     *
     * @param \Magento\OutOfProcessTaxManagement\Api\Data\OutOfProcessTaxIntegrationInterface $tax_integration method to
     * create or update
     * @return \Magento\OutOfProcessTaxManagement\Api\Data\OutOfProcessTaxIntegrationInterface
     * @throws InvalidArgumentException when there's already an active tax integration with different code.
     *
     */
    public function createOrUpdate(OutOfProcessTaxIntegrationInterface $tax_integration):
    OutOfProcessTaxIntegrationInterface;
}
