<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model\Data;

use Magento\Framework\DataObject;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemTaxBreakdownInterface;

class OopQuoteItemTaxBreakdown extends DataObject implements OopQuoteItemTaxBreakdownInterface
{

    /**
     * @return string
     */
    public function getCode(): string
    {
        return (string)$this->getData(self::FIELD_CODE);
    }

    /**
     * @param string $code
     * @return $this
     */
    public function setCode(string $code): self
    {
        $this->setData(self::FIELD_CODE, $code);
        return $this;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return (string)$this->getData(self::FIELD_TITLE);
    }

    /**
     * @param string $title
     * @return $this
     */
    public function setTitle(string $title): self
    {
        $this->setData(self::FIELD_TITLE, $title);
        return $this;
    }

    /**
     * @return float
     */
    public function getRate(): float
    {
        return (float)$this->getData(self::FIELD_RATE);
    }

    /**
     * @param float $taxRate
     * @return $this
     */
    public function setRate(float $taxRate): self
    {
        $this->setData(self::FIELD_RATE, $taxRate);
        return $this;
    }

    /**
     * @return float
     */
    public function getAmount(): float
    {
        return (float)$this->getData(self::FIELD_AMOUNT);
    }

    /**
     * @param float $amount
     * @return $this
     */
    public function setAmount(float $amount): self
    {
        $this->setData(self::FIELD_AMOUNT, $amount);
        return $this;
    }

    /**
     * @return string
     */
    public function getTaxRateKey(): string
    {
        return (string)$this->getData(self::FIELD_TAX_RATE_KEY) ?: "{$this->getCode()}_{$this->getRate()}";
    }

    /**
     * @param string $taxRateKey
     * @return $this
     */
    public function setTaxRateKey(string $taxRateKey): self
    {
        $this->setData(self::FIELD_TAX_RATE_KEY, $taxRateKey);
        return $this;
    }
}
