<?php

namespace Magento\OutOfProcessTaxManagement\Model\Data;

use Magento\Framework\DataObject;
use Magento\OutOfProcessTaxManagement\Api\Data\OopAddressInterface;

class OopAddress extends DataObject implements OopAddressInterface {

    public function getStreet(): ?array
    {
        return $this->getData(self::FIELD_STREET);
    }

    public function setStreet(array $street): self
    {
        $this->setData(self::FIELD_STREET, $street);
        return $this;
    }

    public function getCity(): ?string
    {
        return $this->getData(self::FIELD_CITY);
    }

    public function setCity(string $city): self
    {
        $this->setData(self::FIELD_CITY, $city);
        return $this;
    }

    public function getRegion(): ?string
    {
        return $this->getData(self::FIELD_REGION);
    }

    public function setRegion(string $region): self
    {
        $this->setData(self::FIELD_REGION, $region);
        return $this;
    }

    public function getRegionCode(): ?string
    {
        return $this->getData(self::FIELD_REGION_CODE);
    }

    public function setRegionCode(string $regionCode): self
    {
        $this->setData(self::FIELD_REGION_CODE, $regionCode);
        return $this;
    }

    public function getCountry(): ?string
    {
        return $this->getData(self::FIELD_COUNTRY);
    }

    public function setCountry(string $country): self
    {
        $this->setData(self::FIELD_COUNTRY, $country);
        return $this;
    }

    public function getPostcode(): ?string
    {
        return $this->getData(self::FIELD_POSTCODE);
    }

    public function setPostcode(string $postcode): self
    {
        $this->setData(self::FIELD_POSTCODE, $postcode);
        return $this;
    }
}
