<?php

namespace Magento\OutOfProcessTaxManagement\Api\Data;

interface OopAddressInterface
{

    public const FIELD_STREET = 'street';
    public const FIELD_CITY = 'city';
    public const FIELD_REGION = 'region';
    public const FIELD_REGION_CODE = 'region_code';
    public const FIELD_COUNTRY = 'country';
    public const FIELD_POSTCODE = 'postcode';


    /**
     * @return string[]|null
     */
    public function getStreet(): ?array;

    /**
     * @param string[] $street
     * @return $this
     */
    public function setStreet(array $street): self;

    /**
     * @return string|null
     */
    public function getCity(): ?string;

    /**
     * @param string $city
     * @return $this
     */
    public function setCity(string $city): self;

    /**
     * @return string|null
     */
    public function getRegion(): ?string;

    /**
     * @param string $region
     * @return $this
     */
    public function setRegion(string $region): self;

    /**
     * @return string|null
     */
    public function getRegionCode(): ?string;

    /**
     * @param string $regionCode
     * @return $this
     */
    public function setRegionCode(string $regionCode): self;

    /**
     * @return string|null
     */
    public function getCountry(): ?string;

    /**
     * @param string $country
     * @return $this
     */
    public function setCountry(string $country): self;

    /**
     * @return string|null
     */
    public function getPostcode(): ?string;

    /**
     * @param string $postcode
     * @return $this
     */
    public function setPostcode(string $postcode): self;
}
