<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Api\Data;

/**
 * Represents the overall tax for a quote line item
 *
 * All rates and values are assumed to be calculated correctly
 */
interface OopQuoteItemTaxInterface
{
    public const FIELD_RATE = 'rate';
    public const FIELD_AMOUNT = 'amount';
    public const FIELD_DISCOUNT_COMPENSATION_AMOUNT = 'discount_compensation_amount';

    /**
     * @return float
     */
    public function getRate(): float;

    /**
     * @param float $rate
     * @return $this
     */
    public function setRate(float $rate): self;

    /**
     * @return float
     */
    public function getAmount(): float;

    /**
     * @param float $amount
     * @return $this
     */
    public function setAmount(float $amount): self;

    /**
     * @return float
     */
    public function getDiscountCompensationAmount(): float;

    /**
     * @param float $discountCompensationAmount
     * @return $this
     */
    public function setDiscountCompensationAmount(float $discountCompensationAmount): self;
}
