<?php

declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model\Data;

use Magento\Framework\DataObject;
use Magento\OutOfProcessTaxManagement\Api\Data\OopAddressInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemInterface;

class OopQuote extends DataObject implements OopQuoteInterface
{
    /**
     * @return string|null
     */
    public function getCustomerTaxClass(): ?string
    {
        return (string)$this->getData(self::FIELD_CUSTOMER_TAX_CLASS);
    }

    /**
     * @param string $taxClassName
     * @return $this
     */
    public function setCustomerTaxClass(string $taxClassName): self
    {
        $this->setData(self::FIELD_CUSTOMER_TAX_CLASS, $taxClassName);
        return $this;
    }

    /**
     * @return OopQuoteItemInterface[]
     */
    public function getItems(): array
    {
        $quoteItems = $this->getData(self::FIELD_ITEMS);
        if (is_array($quoteItems)) {
            return $quoteItems;
        }
        return [];
    }

    /**
     * @param OopQuoteItemInterface[] $items
     * @return OopQuoteInterface
     */
    public function setItems(array $items): self
    {
        $this->setData(self::FIELD_ITEMS, $items);
        return $this;
    }

    /**
     * @return OopAddressInterface
     */
    public function getShipFromAddress(): OopAddressInterface
    {
        return $this->getData(self::FIELD_SHIP_FROM_ADDRESS);
    }

    /**
     * @param OopAddressInterface $shipFromAddress
     * @return OopQuoteInterface
     */
    public function setShipFromAddress(OopAddressInterface $shipFromAddress): OopQuoteInterface
    {
        $this->setData(self::FIELD_SHIP_FROM_ADDRESS, $shipFromAddress);
        return $this;
    }

    /**
     * @return OopAddressInterface
     */
    public function getShipToAddress(): OopAddressInterface
    {
        return $this->getData(self::FIELD_SHIP_TO_ADDRESS);
    }

    /**
     * @param OopAddressInterface $shipToAddress
     * @return OopQuoteInterface
     */
    public function setShipToAddress(OopAddressInterface $shipToAddress): OopQuoteInterface
    {
        $this->setData(self::FIELD_SHIP_TO_ADDRESS, $shipToAddress);
        return $this;
    }

    /**
     * @return OopAddressInterface
     */
    public function getBillingAddress(): OopAddressInterface
    {
        return $this->getData(self::FIELD_BILLING_ADDRESS);
    }

    /**
     * @param OopAddressInterface $billingAddress
     * @return OopQuoteInterface
     */
    public function setBillingAddress(OopAddressInterface $billingAddress): OopQuoteInterface
    {
        $this->setData(self::FIELD_BILLING_ADDRESS, $billingAddress);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getShippingMethod(): ?string
    {
        return $this->getData(self::FIELD_SHIPPING_METHOD);
    }

    /**
     * @inheritDoc
     */
    public function setShippingMethod(?string $shippingMethod): self
    {
        $this->setData(self::FIELD_SHIPPING_METHOD, $shippingMethod);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getShippingDescription(): ?string
    {
        return $this->getData(self::FIELD_SHIPPING_DESCRIPTION);
    }

    /**
     * @inheritDoc
     */
    public function setShippingDescription(?string $shippingDescription): self
    {
        $this->setData(self::FIELD_SHIPPING_DESCRIPTION, $shippingDescription);
        return $this;
    }

    /**
     * @inheritDoc
     */
    public function getCustomAttributes(): array
    {
        return $this->getData(self::FIELD_CUSTOM_ATTRIBUTES) ?? [];
    }

    /**
     * @inheritDoc
     */
    public function setCustomAttributes(array $customAttributes): self
    {
        $this->setData(self::FIELD_CUSTOM_ATTRIBUTES, $customAttributes);
        return $this;
    }
}
