<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Api;

use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteInterface;
use Magento\Tax\Api\Data\QuoteDetailsInterface;
use Magento\Tax\Api\Data\TaxDetailsInterface;

interface OopTaxCalculationInterface
{
    /**
     * Calculate Tax
     *
     * @param QuoteDetailsInterface $quoteDetails
     * @param OopQuoteInterface $oopQuote
     * @param int|null $storeId
     * @param bool $round
     * @return TaxDetailsInterface
     */
    public function calculateTaxes(
        QuoteDetailsInterface $quoteDetails,
        OopQuoteInterface     $oopQuote,
        int                   $storeId = null,
        bool                  $round = true
    ) : TaxDetailsInterface;

    /**
     * Calculate tax values for the OopQuote object based on currency conversion.
     * This method returns a new OopQuoteInterface object with updated currency values.
     *
     * @param OopQuoteInterface $baseOopQuote
     * @param float $currencyRate
     * @return OopQuoteInterface
     */
    public function calculateTaxCurrencies(OopQuoteInterface $baseOopQuote, float $currencyRate): OopQuoteInterface;
}
