<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Api\Data;

/**
 * Represents a single quote line item
 *
 * OopQuoteItemTaxDetails is expected to be added by an external system during collectTaxes webhook call
 */
interface OopQuoteItemInterface
{
    public const FIELD_CODE = 'code';
    public const FIELD_TYPE = 'type';
    public const FIELD_TAX_CLASS = 'tax_class';
    public const FIELD_UNIT_PRICE = 'unit_price';
    public const FIELD_DISCOUNT_AMOUNT = 'discount_amount';
    public const FIELD_QUANTITY = 'quantity';
    public const FIELD_IS_TAX_INCLUDED = 'is_tax_included';
    public const FIELD_CUSTOM_ATTRIBUTES = 'custom_attributes';
    public const FIELD_SKU = 'sku';
    public const FIELD_NAME = 'name';

    // expected to be set by an external system during collectTaxes webhook call
    public const FIELD_TAX = 'tax';
    public const FIELD_TAX_BREAKDOWN = 'tax_breakdown';

    /**
     * @return string
     */
    public function getCode(): string;

    /**
     * @param string $code
     * @return $this
     */
    public function setCode(string $code): self;

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @param string $type
     * @return $this
     */
    public function setType(string $type): self;

    /**
     * @return string|null
     */
    public function getTaxClass(): ?string;

    /**
     * @param string $taxClass
     * @return $this
     */
    public function setTaxClass(string $taxClass): self;

    /**
     * @return float
     */
    public function getUnitPrice(): float;

    /**
     * @param float $unitPrice
     * @return $this
     */
    public function setUnitPrice(float $unitPrice): self;

    /**
     * @return float
     */
    public function getQuantity(): float;

    /**
     * @param float $quantity
     * @return $this
     */
    public function setQuantity(float $quantity): self;

    /**
     * @return bool
     */
    public function getIsTaxIncluded(): bool;

    /**
     * @param bool $isTaxIncluded
     * @return $this
     */
    public function setIsTaxInclude(bool $isTaxIncluded): self;

    /**
     * @return float
     */
    public function getDiscountAmount(): float;

    /**
     * @param float $discountAmount
     * @return $this
     */
    public function setDiscountAmount(float $discountAmount): self;

    /**
     * Custom attributes including custom tax codes
     * @return array
     */
    public function getCustomAttributes(): array;

    /**
     * @param array $customAttributes
     * @return self
     */
    public function setCustomAttributes(array $customAttributes): self;

    /**
     * @return string|null
     */
    public function getSku(): ?string;

    /**
     * @param string $sku
     * @return $this
     */
    public function setSku(string $sku): self;

    /**
     * @return string|null
     */
    public function getName(): ?string;

    /**
     * @param string $name
     * @return $this
     */
    public function setName(string $name): self;

    /**
     * @return OopQuoteItemTaxInterface|null
     */
    public function getTax(): ?OopQuoteItemTaxInterface;

    /**
     * Expects a tax object to be set by an external system during collectTaxes webhook call
     * @param OopQuoteItemTaxInterface $tax
     * @return $this
     */
    public function setTax(OopQuoteItemTaxInterface $tax): self;

    /**
     * @return OopQuoteItemTaxBreakdownInterface[]|null
     */
    public function getTaxBreakdown(): ?array;

    /**
     * Expects a tax breakdown to be set by an external system during collectTaxes webhook call
     * @param OopQuoteItemTaxBreakdownInterface[] $taxBreakdown
     * @return $this
     */
    public function setTaxBreakdown(array $taxBreakdown): self;
}
