<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Plugin;

use Magento\Quote\Model\Quote\Item\AbstractItem;
use Magento\Tax\Api\Data\QuoteDetailsItemInterface;
use Magento\Tax\Api\Data\QuoteDetailsItemInterfaceFactory;
use Magento\Tax\Model\Sales\Total\Quote\CommonTaxCollector;

class AddProductInformationToQuoteDetailsItem
{
    /**
     * After plugin for mapItem method
     *
     * @param CommonTaxCollector $subject
     * @param QuoteDetailsItemInterface $result
     * @param QuoteDetailsItemInterfaceFactory $itemDataObjectFactory
     * @param AbstractItem $item
     * @return QuoteDetailsItemInterface
     */
    public function afterMapItem(
        CommonTaxCollector $subject,
        QuoteDetailsItemInterface $result,
        QuoteDetailsItemInterfaceFactory $itemDataObjectFactory,
        AbstractItem $item
    ): QuoteDetailsItemInterface {
        if ($result->getType() == CommonTaxCollector::ITEM_TYPE_PRODUCT) {
            $extensionAttributes = $result->getExtensionAttributes();
            $extensionAttributes->setProductName($this->getProductName($item));
            $extensionAttributes->setProductSku($this->getProductSku($item));
            $result->setExtensionAttributes($extensionAttributes);
        }
        return $result;
    }

    /**
     * @param AbstractItem $item
     * @return string|null
     */
    public function getProductName(AbstractItem $item): ?string
    {
        return $item->getProduct()?->getName();
    }

    /**
     * @param AbstractItem $item
     * @return string|null
     */
    private function getProductSku(AbstractItem $item)
    {
        return $item->getProduct()?->getSku();
    }
}
