<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model\Helper;

use Magento\Customer\Api\Data\AddressInterface;
use Magento\Directory\Model\Region;
use Magento\Directory\Model\ResourceModel\Region\Collection as RegionCollection;

class RegionHelper
{

    public function __construct(
        private readonly RegionCollection     $regionCollection
    ) {
    }

    /**
     * @param AddressInterface|null $address
     * @return Region|null
     */
    public function getRegion(?AddressInterface $address): ?Region
    {
        $regionId = $address?->getRegion()?->getRegionId() ?: $address?->getRegionId();
        if ($regionId == null) {
            return null;
        }
        return $this->regionCollection->getItemById(intval($regionId));
    }
}
