<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Api\Data;

use Magento\Framework\Exception\NoSuchEntityException;

interface OutOfProcessTaxIntegrationInterface
{
    public const FIELD_CODE = 'code';
    public const FIELD_TITLE = 'title';
    public const FIELD_ACTIVE = 'active';
    public const FIELD_STORE_IDS = 'store_ids';

    /**
     * Tax integration code
     *
     * @return string
     */
    public function getCode(): string;

    /**
     * Set the tax integration code
     *
     * @param string $code
     * @return $this
     */
    public function setCode(string $code): self;

    /**
     * Tax integration title
     *
     * @return string
     */
    public function getTitle(): string;

    /**
     * Set the tax integration title
     *
     * @param string $title
     * @return $this
     */
    public function setTitle(string $title): self;

    /**
     * Whether the tax integration is active
     *
     * @return bool
     */
    public function isActive(): bool;

    /**
     * Set whether the tax integration is active
     *
     * @param bool $active
     * @return $this
     */
    public function setActive(bool $active): self;

    /**
     * The store codes where the tax integration is active.
     * If not set or empty, tax integration will be available for all store codes.
     *
     * @return string[] list of store codes
     * @throws NoSuchEntityException If any of the specified store codes do not exist
     */
    public function getStores(): array;

    /**
     * Set the store codes where the tax integration is active.
     * @param string[] $stores
     * @return $this
     * @throws NoSuchEntityException If any of the specified store codes do not exist
     */
    public function setStores(array $stores): self;
}
