<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Api\Data;

/**
 * Represents a single tax code for an item
 *
 * Used by OopQuoteItemTaxDetailsInterface and expected to be populated by an external system during collectTaxes webhook call
 *
 * Response from webhook is transformed into \Magento\Tax\Api\Data\AppliedTaxInterface
 *
 * All rates and values are assumed to calculated correctly
 */
interface OopQuoteItemTaxBreakdownInterface
{
    public const FIELD_CODE = 'code';
    public const FIELD_TITLE = 'title';
    public const FIELD_RATE = 'rate';
    public const FIELD_AMOUNT = 'amount';
    public const FIELD_TAX_RATE_KEY = 'tax_rate_key';

    /**
     * code of the tax
     *
     * @return string
     */
    public function getCode(): string;

    /**
     * @param string $code
     * @return $this
     */
    public function setCode(string $code): self;

    /**
     * title for display
     * @return string
     */
    public function getTitle(): string;

    /**
     * @param string $title
     * @return $this
     */
    public function setTitle(string $title): self;

    /**
     * tax rate percentage
     *
     * @return float
     */
    public function getRate(): float;

    /**
     * @param float $rate
     * @return $this
     */
    public function setRate(float $rate): self;

    /**
     * tax amount
     * @return float
     */
    public function getAmount(): float;

    /**
     * @param float $amount
     * @return $this
     */
    public function setAmount(float $amount): self;

    /**
     * key used to sum taxes across lines
     *
     * @return string
     */
    public function getTaxRateKey(): string;

    /**
     * @param string $taxRateKey
     * @return $this
     */
    public function setTaxRateKey(string $taxRateKey): self;
}
