<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Api\Data;

/**
 * Represents a quote
 */
interface OopQuoteInterface
{
    public const FIELD_SHIP_FROM_ADDRESS = 'ship_from_address';
    public const FIELD_SHIP_TO_ADDRESS = 'ship_to_address';
    public const FIELD_BILLING_ADDRESS = 'billing_address';
    public const FIELD_CUSTOMER_TAX_CLASS = 'customer_tax_class';
    public const FIELD_ITEMS = 'items';
    public const FIELD_CUSTOM_ATTRIBUTES = 'custom_attributes';

    /**
     * @return string|null
     */
    public function getCustomerTaxClass(): ?string;

    /**
     * @param string $taxClassName
     * @return $this
     */
    public function setCustomerTaxClass(string $taxClassName): self;

    /**
     * @return OopQuoteItemInterface[]
     */
    public function getItems(): array;

    /**
     * @param OopQuoteItemInterface[] $items
     * @return OopQuoteInterface
     */
    public function setItems(array $items): self;

    /**
     * @return OopAddressInterface
     */
    public function getShipFromAddress(): OopAddressInterface;

    /**
     * @param OopAddressInterface $shipFromAddress
     * @return self
     */
    public function setShipFromAddress(OopAddressInterface $shipFromAddress): self;

    /**
     * @return OopAddressInterface
     */
    public function getShipToAddress(): OopAddressInterface;

    /**
     * @param OopAddressInterface $shipToAddress
     * @return self
     */
    public function setShipToAddress(OopAddressInterface $shipToAddress): self;

    /**
     * @return OopAddressInterface
     */
    public function getBillingAddress(): OopAddressInterface;

    /**
     * @param OopAddressInterface $billingAddress
     * @return self
     */
    public function setBillingAddress(OopAddressInterface $billingAddress): self;

    /**
     * @return array
     */
    public function getCustomAttributes(): array;

    /**
     * @param array $customAttributes
     * @return self
     */
    public function setCustomAttributes(array $customAttributes): self;
}
