<?php

namespace Magento\OutOfProcessTaxManagement\Model\Helper;

use Magento\OutOfProcessTaxManagement\Api\Data\OopCustomerInterface;
use Magento\OutOfProcessTaxManagement\Model\Data\OopCustomerFactory;
use Magento\Quote\Model\Quote;
use Magento\Customer\Model\Session;
use Magento\Customer\Model\CustomerFactory;

class CustomerHelper
{
    public function __construct(
        private readonly CustomerFactory $customerFactory,
        private readonly Session $session,
        private readonly OopCustomerFactory $oopCustomerFactory
    )
    {
    }

    /**
     * @param Quote $quote
     * @return OopCustomerInterface|null
     */
    public function getCustomer(Quote $quote) : ?OopCustomerInterface
    {
        $customerEntity = $quote->getCustomer();

        if ($customerEntity?->getId()) {
            $oopCustomer = $this->oopCustomerFactory->create();
            $oopCustomer->setEntityId((int)$customerEntity->getId());
            $oopCustomer->setWebsiteId((int)$customerEntity->getWebsiteId());
            $oopCustomer->setGroupId((int)$customerEntity->getGroupId());
            $oopCustomer->setEmail((string)$customerEntity->getEmail());
            $oopCustomer->setFirstname((string)$customerEntity->getFirstname());
            $oopCustomer->setMiddlename((string)$customerEntity->getMiddlename());
            $oopCustomer->setLastname((string)$customerEntity->getLastname());
            return $oopCustomer;
        }

        return null;
    }
}
