<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model\ResourceModel;

use Magento\Framework\DataObject;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

/**
 * @inheritDoc
 */
class OutOfProcessTaxIntegration extends AbstractDb
{

    /**
     * @var array map of fields that should be serialized
     */
    protected $_serializableFields = [
        'store_ids' => [[], []],
    ];

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init('oope_tax_integration', 'id');
    }

    /**
     * Provides custom serialization.
     *
     * @param DataObject $object
     * @param string $field
     * @param mixed $defaultValue
     * @param bool $unsetEmpty
     * @return $this
     */
    protected function _serializeField(
        DataObject $object,
        $field,
        $defaultValue = null,
        $unsetEmpty = false
    ) {
        return parent::_serializeField($object, $field, $defaultValue, $unsetEmpty);
    }

    /**
     * Provides custom deserialization.
     *
     * @param DataObject $object
     * @param string $field
     * @param mixed $defaultValue
     * @return void
     */
    protected function _unserializeField(DataObject $object, $field, $defaultValue = null)
    {
        parent::_unserializeField($object, $field, $defaultValue);
    }
}
