<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model\Helper;

use Magento\Directory\Model\Region;
use Magento\Directory\Model\ResourceModel\Region\Collection as RegionCollection;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\DataObject;
use Magento\Shipping\Model\Config as ShippingConfig;
use Magento\Store\Model\ScopeInterface;

class ShippingOriginHelper
{

    public const XML_PATH_ORIGIN_STREET1 = 'shipping/origin/street_line1';
    public const XML_PATH_ORIGIN_STREET2 = 'shipping/origin/street_line2';

    public function __construct(
        private readonly ScopeConfigInterface $scopeConfig,
        private readonly RegionCollection     $regionCollection
    ) {
    }

    /**
     * @return array
     */
    public function getStreet(): array
    {
        $streetLines = [];

        $firstLine = $this->scopeConfig->getValue(self::XML_PATH_ORIGIN_STREET1, ScopeInterface::SCOPE_STORE);
        if ($firstLine != null) {
            $streetLines[] = $firstLine;
        }

        $secondLine = $this->scopeConfig->getValue(self::XML_PATH_ORIGIN_STREET2, ScopeInterface::SCOPE_STORE);
        if ($secondLine != null) {
            $streetLines[] = $secondLine;
        }

        return $streetLines;
    }

    /**
     * @return string|null
     */
    public function getCity(): ?string
    {
        return $this->scopeConfig->getValue(ShippingConfig::XML_PATH_ORIGIN_CITY, ScopeInterface::SCOPE_STORE);
    }

    /**
     * @return string|null
     */
    public function getRegionId(): ?string
    {
        return $this->scopeConfig->getValue(ShippingConfig::XML_PATH_ORIGIN_REGION_ID, ScopeInterface::SCOPE_STORE);
    }

    /**
     * @return Region|null
     */
    public function getRegion(): ?DataObject
    {
        $regionId = $this->getRegionId();
        if ($regionId == null) {
            return null;
        }
        return $this->regionCollection->getItemById($regionId);
    }

    /**
     * @return string|null
     */
    public function getCountryId(): ?string
    {
        return $this->scopeConfig->getValue(ShippingConfig::XML_PATH_ORIGIN_COUNTRY_ID, ScopeInterface::SCOPE_STORE);
    }

    /**
     * @return string|null
     */
    public function getPostcode(): ?string
    {
        return $this->scopeConfig->getValue(ShippingConfig::XML_PATH_ORIGIN_POSTCODE, ScopeInterface::SCOPE_STORE);
    }
}
