<?php

namespace Magento\OutOfProcessTaxManagement\Model\Helper;

use Magento\OutOfProcessTaxManagement\Api\Data\OopCustomerInterface;
use Magento\OutOfProcessTaxManagement\Model\Data\OopCustomerFactory;
use Magento\Quote\Model\Quote;
use Magento\Customer\Model\ResourceModel\Customer as CustomerResource;
use Magento\Customer\Model\Session;
use Magento\Customer\Model\CustomerFactory;

class CustomerHelper
{
    public function __construct(
        private readonly CustomerFactory $customerFactory,
        private readonly CustomerResource $customerResource,
        private readonly Session $session,
        private readonly OopCustomerFactory $oopCustomerFactory
    )
    {
    }

    /**
     * @param Quote $quote
     * @return OopCustomerInterface|null
     */
    public function getCustomer(Quote $quote) : ?OopCustomerInterface
    {
        $customerId = $quote->getCustomerId();
        if (!$customerId) {
            return null;
        }

        $customerEntity = $this->customerFactory->create();
        $this->customerResource->load($customerEntity, $customerId);

        if ($customerEntity->getEntityId()) {
            $oopCustomer = $this->oopCustomerFactory->create();
            $oopCustomer->setEntityId((int)$customerEntity->getEntityId());
            $oopCustomer->setWebsiteId((int)$customerEntity->getWebsiteId());
            $oopCustomer->setGroupId((int)$customerEntity->getGroupId());
            $oopCustomer->setEmail((string)$customerEntity->getEmail());
            $oopCustomer->setFirstname((string)$customerEntity->getFirstname());
            $oopCustomer->setLastname((string)$customerEntity->getLastname());
            return $oopCustomer;
        }

        return null;
    }
}
