<?php

declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagement\Model\Data;

use Magento\Framework\DataObject;
use Magento\OutOfProcessTaxManagement\Api\Data\OopAddressInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopCustomerInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteItemInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopShippingInterface;

class OopCustomer extends DataObject implements OopCustomerInterface
{

    public function getEntityId(): ?int
    {
        return $this->getData(self::FIELD_ENTITY_ID);
    }

    public function setEntityId(int $entityId): OopCustomerInterface
    {
        $this->setData(self::FIELD_ENTITY_ID, $entityId);
        return $this;
    }

    public function getWebsiteId(): ?int
    {
        return $this->getData(self::FIELD_WEBSITE_ID);
    }

    public function setWebsiteId(int $websiteId): OopCustomerInterface
    {
        $this->setData(self::FIELD_WEBSITE_ID, $websiteId);
        return $this;
    }

    public function getGroupId(): ?int
    {
        return $this->getData(self::FIELD_GROUP_ID);
    }

    public function setGroupId(int $groupId): OopCustomerInterface
    {
        $this->setData(self::FIELD_GROUP_ID, $groupId);
        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->getData(self::FIELD_EMAIL);
    }

    public function setEmail(string $email): OopCustomerInterface
    {
        $this->setData(self::FIELD_EMAIL, $email);
        return $this;
    }

    public function getFirstname(): ?string
    {
        return $this->getData(self::FIELD_FIRSTNAME);
    }

    public function setFirstname(string $firstname): OopCustomerInterface
    {
        $this->setData(self::FIELD_FIRSTNAME, $firstname);
        return $this;
    }

    public function getLastname(): ?string
    {
        return $this->getData(self::FIELD_LASTNAME);
    }

    public function setLastname(string $lastname): OopCustomerInterface
    {
        $this->setData(self::FIELD_LASTNAME, $lastname);
        return $this;
    }
}
