<?php
declare(strict_types=1);

namespace Magento\OutOfProcessTaxManagementTest\Plugin;

use Magento\OutOfProcessTaxManagement\Api\OopTaxCollectionInterface;
use Magento\OutOfProcessTaxManagement\Api\Data\OopQuoteInterface;
use Magento\OutOfProcessTaxManagement\Model\Data\OopQuoteItemTax;
use Magento\OutOfProcessTaxManagement\Model\Data\OopQuoteItemTaxBreakdown;

class TaxCollector
{
    private const array TAXES = [
        [
            "code" => "state_tax",
            "title" => "State Tax",
            "rate" => .03,
        ],
        [
            "code" => "country_tax",
            "title" => "Country Tax",
            "rate" => .02,
        ],
    ];

    /**
     * Before plugin for collectTaxes to emulate the tax webhook behavior
     *
     * @param OopTaxCollectionInterface $subject
     * @param OopQuoteInterface $oopQuote
     * @return OopQuoteInterface
     */
    public function beforeCollectTaxes(
        OopTaxCollectionInterface $subject,
        OopQuoteInterface $oopQuote
    ): array {
        foreach ($oopQuote->getItems() as $key => $item) {
            $itemTaxAmount = 0;
            foreach (self::TAXES as $tax) {
                $taxAmount = ($item["unit_price"] * $item["quantity"] * $tax["rate"]);
                $itemTaxAmount += $taxAmount;
                $item->setTaxBreakdown(
                    array_merge(
                        $item->getTaxBreakdown(),
                        [
                            new OopQuoteItemTaxBreakdown(
                                [
                                    OopQuoteItemTaxBreakdown::FIELD_CODE => $tax["code"],
                                    OopQuoteItemTaxBreakdown::FIELD_TITLE => $tax["title"],
                                    OopQuoteItemTaxBreakdown::FIELD_RATE => $tax["rate"],
                                    OopQuoteItemTaxBreakdown::FIELD_AMOUNT => $taxAmount,
                                    OopQuoteItemTaxBreakdown::FIELD_TAX_RATE_KEY => "state_tax-" . $tax["rate"]
                                ]
                            )
                        ]
                    )

                );
            }
            $itemTaxRate = ($itemTaxAmount / ($item["unit_price"] * $item["quantity"]));
            $item->setTax(
                new OopQuoteItemTax(
                    [
                        OopQuoteItemTax::FIELD_RATE => $itemTaxRate,
                        OopQuoteItemTax::FIELD_AMOUNT => $itemTaxAmount,
                    ]
                )
            );
        }
        return [$oopQuote];
    }
}
