<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Plugin\Quote\Api;

use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Api\PaymentMethodManagementInterface;
use Psr\Log\LoggerInterface;

/**
 * Set additionalInformation on payment for OutOfProcessPaymentMethods method
 */
class PaymentMethodManagementInterfaceAfterSetPlugin
{
    public function __construct(
        private readonly LoggerInterface $logger,
        private readonly CartRepositoryInterface $cartRepository
    ) {
    }

    /**
     * @param PaymentMethodManagementInterface $subject
     * @param mixed $result
     * @param int $cartId
     * @param \Magento\Quote\Api\Data\PaymentInterface $method
     * @return mixed
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function afterSet(PaymentMethodManagementInterface $subject, mixed $result, int $cartId, \Magento\Quote\Api\Data\PaymentInterface $method): mixed
    {
        $this->logger->debug("PaymentMethodManagementInterfaceAfterSetPlugin::afterSet");

        $cart = $this->cartRepository->get($cartId);
        $payment = $cart->getPayment();

        foreach ($this->extractAdditionalInformation($method) as $key => $data) {
            $payment->setAdditionalInformation($key, $data);
        }

        $payment->save();

        return $result;
    }

    /**
     * @param \Magento\Quote\Api\Data\PaymentInterface $method
     * @return array
     */
    private function extractAdditionalInformation(\Magento\Quote\Api\Data\PaymentInterface $method): array
    {
        $paymentInformation = [];

        foreach ((array)$method->getAdditionalData() as $aditionalData) {
            $parts = explode('=', $aditionalData, 2);
            if (count($parts) == 2) {
                $paymentInformation[$parts[0]] = $parts[1];
            }
        }

        return $paymentInformation;
    }
}

