<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Model;

use Magento\Framework\DataObject;
use Magento\OutOfProcessPaymentMethods\Api\Data\CustomConfigKeyValueInterface;

class CustomConfigKeyValue extends DataObject implements CustomConfigKeyValueInterface
{

    /**
     * @inheritdoc
     */
    public function getKey(): string
    {
        return $this->getData(self::KEY);
    }

    /**
     * @inheritdoc
     */
    public function setKey($key): self
    {
        return $this->setData(self::KEY, $key);
    }

    /**
     * @inheritdoc
     */
    public function getValue(): string
    {
        return $this->getData(self::VALUE);
    }

    /**
     * @inheritdoc
     */
    public function setValue($value): self
    {
        return $this->setData(self::VALUE, $value);
    }
}
