<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);
namespace Magento\OutOfProcessPaymentMethods\Model\Resolver;

use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\Resolver\Value;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\OutOfProcessPaymentMethods\Api\Data\OutOfProcessPaymentMethodInterface;
use Magento\OutOfProcessPaymentMethods\Api\OutOfProcessPaymentMethodRepositoryInterface;
use Magento\OutOfProcessPaymentMethods\Model\Helper\Data as PaymentMethodHelper;

class OopePaymentMethodConfig implements ResolverInterface
{
    /**
     * @param PaymentMethodHelper $paymentMethodHelper
     * @param OutOfProcessPaymentMethodRepositoryInterface $paymentMethodRepository
     */
    public function __construct(
        private readonly PaymentMethodHelper                          $paymentMethodHelper,
        private readonly OutOfProcessPaymentMethodRepositoryInterface $paymentMethodRepository
    ) {
    }

    /**
     * Fetches the data from persistence models and format it according to the GraphQL schema.
     *
     * @param \Magento\Framework\GraphQl\Config\Element\Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return mixed|Value
     * @throws \Exception
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function resolve(Field $field, $context, ResolveInfo $info, ?array $value = null, ?array $args = null)
    {
        $methodCode = $value['code'];
        if (!$this->paymentMethodHelper->isOutOfProcess($methodCode)) {
            return null;
        }
        $paymentMethod = $this->paymentMethodRepository->getByCode($methodCode);
        return $paymentMethod->toArray([
            OutOfProcessPaymentMethodInterface::FIELD_BACKEND_INTEGRATION_URL,
            OutOfProcessPaymentMethodInterface::FIELD_CUSTOM_CONFIG
        ]);
    }
}
