<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Model;

use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Framework\DataObject;
use Magento\OutOfProcessPaymentMethods\Api\Data\PaymentMethodFilterPayloadInterface;
use Magento\Quote\Api\Data\CartInterface;

/**
 * @inheritDoc
 */
class PaymentMethodFilterPayload extends DataObject implements PaymentMethodFilterPayloadInterface
{
    /**
     * @inheritDoc
     */
    public function getCart(): CartInterface
    {
        return $this->getData(self::FIELD_CART);
    }

    /**
     * @inheritDoc
     */
    public function getCustomer(): ?CustomerInterface
    {
        return $this->getData(self::FIELD_CUSTOMER);
    }

    /**
     * @inheritDoc
     */
    public function getAvailablePaymentMethods(): array
    {
        return $this->getData(self::FIELD_AVAILABLE_PAYMENT_METHODS);
    }
}
