<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Model;

/**
 * Pool model for AdditionalDataProvider
 */
class OutOfProcessAdditionalDataProviderPool
{
    /**
     * @var AdditionalDataProviderInterface[]
     */
    private $dataProviders;

    /**
     * @param array $dataProviders
     */
    public function __construct(array $dataProviders = [])
    {
        $this->dataProviders = $dataProviders;
    }

    /**
     * Return payment information for the payment method.
     *
     * @param array $data
     * @return array
     */
    public function getPaymentInformation(array $data): array
    {
        $paymentInformation = [];
        if (isset($this->dataProviders['additional_data'])) {
            $paymentInformation = $this->dataProviders['additional_data']->getData($data);
        }

        return $paymentInformation;
    }
}
