<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Api;

use Magento\OutOfProcessPaymentMethods\Api\Data\PaymentMethodFilterPayloadInterface;

/**
 * This interface is used to provide a list of payment methods that should be filtered during checkout.
 */
interface PaymentMethodFilterInterface
{
    /**
     * Returns a list of payment methods that should be filtered during checkout.
     *
     * @param PaymentMethodFilterPayloadInterface $payload
     * @return array
     */
    public function getList(PaymentMethodFilterPayloadInterface $payload): array;
}
