<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Api;

use Magento\Framework\Exception\NoSuchEntityException;
use Magento\OutOfProcessPaymentMethods\Api\Data\OutOfProcessPaymentMethodInterface;

interface OutOfProcessPaymentMethodRepositoryInterface
{

    /**
     * Retrieves an out of process payment method
     *
     * @param string $code to lookup
     * @return \Magento\OutOfProcessPaymentMethods\Api\Data\OutOfProcessPaymentMethodInterface
     * @throws NoSuchEntityException when out of process payment method can't be found
     */
    public function getByCode(string $code): OutOfProcessPaymentMethodInterface;

    /**
     * Retrieves the list of out of process payment methods
     *
     * @return \Magento\OutOfProcessPaymentMethods\Api\Data\OutOfProcessPaymentMethodInterface[]
     */
    public function getList(): array;

    /**
     * Creates or updates an out of process payment method
     *
     * @param \Magento\OutOfProcessPaymentMethods\Api\Data\OutOfProcessPaymentMethodInterface $payment_method method to
     * create or update
     * @return \Magento\OutOfProcessPaymentMethods\Api\Data\OutOfProcessPaymentMethodInterface
     */
    public function createOrUpdate(OutOfProcessPaymentMethodInterface $payment_method):
    OutOfProcessPaymentMethodInterface;
}
