<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2025 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */
declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Api\Data;

use Magento\Customer\Api\Data\CustomerInterface;
use Magento\Quote\Api\Data\CartInterface;

/**
 * Interface for the payment method filter payload.
 */
interface PaymentMethodFilterPayloadInterface
{
    public const FIELD_CART = 'cart';
    public const FIELD_CUSTOMER = 'customer';
    public const FIELD_AVAILABLE_PAYMENT_METHODS = 'available_payment_methods';

    /**
     * Returns the cart object.
     *
     * @return CartInterface
     */
    public function getCart(): CartInterface;

    /**
     * Returns the customer object.
     *
     * @return CustomerInterface|null
     */
    public function getCustomer(): ?CustomerInterface;

    /**
     * Returns an array of available payment methods.
     *
     * @return array
     */
    public function getAvailablePaymentMethods(): array;
}
