<?php
/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Api\Data;

use Magento\Framework\Exception\NoSuchEntityException;

interface OutOfProcessPaymentMethodInterface
{
    public const FIELD_CODE = 'code';
    public const FIELD_TITLE = 'title';
    public const FIELD_ACTIVE = 'active';
    public const FIELD_BACKEND_INTEGRATION_URL = 'backend_integration_url';
    public const FIELD_STORE_IDS = 'store_ids';
    public const FIELD_ORDER_STATUS = 'order_status';
    public const FIELD_COUNTRIES = 'countries';
    public const FIELD_CURRENCIES = 'currencies';
    public const FIELD_CUSTOM_CONFIG = 'custom_config';

    /**
     * The ID of the payment method
     *
     * @return int|null
     */
    public function getId();

    /**
     * Set the ID of the payment method
     *
     * @param int|null $id
     * @return $this
     */
    public function setId($id);

    /**
     * Code of the payment method, must be unique including the regular payment methods
     *
     * @return string
     */
    public function getCode(): string;

    /**
     *  Set the code of the payment method
     *
     * @param string $code
     * @return $this
     */
    public function setCode(string $code): self;

    /**
     * Title of the payment method
     *
     * @return string
     */
    public function getTitle(): string;

    /**
     * Set the title of the payment method
     *
     * @param string $title
     * @return $this
     */
    public function setTitle(string $title): self;

    /**
     * Whether the payment method is active or not
     *
     * @return bool
     */
    public function isActive(): bool;

    /**
     * Set the active status of the payment method
     *
     * @param bool $active
     * @return $this
     */
    public function setActive(bool $active): self;

    /**
     * The backend URL to dispatch requests related to the payment method
     *
     * @return string
     */
    public function getBackendIntegrationUrl(): string;

    /**
     * Set the backend URL to dispatch requests related to the payment method
     *
     * @param string $backendIntegrationUrl
     * @return $this
     */
    public function setBackendIntegrationUrl(string $backendIntegrationUrl): self;

    /**
     * The store codes where this payment method is available.
     *
     * If not set or empty, payment method will be available for all store codes.
     *
     * @return string[] list of store codes
     * @throws NoSuchEntityException
     */
    public function getStores(): array;

    /**
     * Set the store codes where this payment method is available
     *
     * @param string[] $stores
     * @return $this
     * @throws NoSuchEntityException
     */
    public function setStores(array $stores): self;

    /**
     * Initial order status, if not set configured default will be used
     *
     * @return string|null
     */
    public function getOrderStatus(): ?string;

    /**
     * Set the order status
     *
     * @param string|null $orderStatus
     * @return $this
     */
    public function setOrderStatus(?string $orderStatus): self;

    /**
     * The countries where this payment method is available.
     *
     * If not set or empty, payment method will be available for all countries.
     *
     * @return string[] list of country codes in ISO-3166 (alpha-2)
     */
    public function getCountries(): array;

    /**
     * Set the countries where this payment method is available
     *
     * @param string[] $countries
     * @return $this
     */
    public function setCountries(?array $countries): self;

    /**
     * The currencies can be used with this payment method.
     *
     * If not set or empty, payment method accepts all currencies.
     *
     * @return string[] list of currency codes in ISO-4217
     */
    public function getCurrencies(): array;

    /**
     * Set the currencies can be used with this payment method
     *
     * @param string[] $currencies
     * @return $this
     */
    public function setCurrencies(?array $currencies): self;

    /**
     * Get the custom configuration for the payment method
     *
     * @return \Magento\OutOfProcessPaymentMethods\Api\Data\CustomConfigKeyValueInterface[]
     */
    public function getCustomConfig(): array;

    /**
     * Set the custom configuration for the payment method
     *
     * @param \Magento\OutOfProcessPaymentMethods\Api\Data\CustomConfigKeyValueInterface[] $customConfig
     * @return $this
     */
    public function setCustomConfig(array $customConfig);
}
