<?php

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Test\Integration;

use Magento\Framework\ObjectManagerInterface;
use Magento\OutOfProcessPaymentMethods\Api\Data\OutOfProcessPaymentMethodInterfaceFactory;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\Catalog\Api\Data\ProductInterfaceFactory;
use Magento\Quote\Model\QuoteFactory;
use Magento\Quote\Api\Data\CartItemInterfaceFactory;
use PHPUnit\Framework\TestCase;
use \Magento\OutOfProcessPaymentMethods\Api\OutOfProcessPaymentMethodRepositoryInterface;
use \Magento\Payment\Helper\Data;

class GetPaymentMethodsTest extends TestCase
{
    const string OOP_PAYMENT_METHOD_CODE = 'oop_payment_method_code';
    private ?ObjectManagerInterface $objectManager;

    private ?OutOfProcessPaymentMethodRepositoryInterface $paymentMethodRepository;

    private ?OutOfProcessPaymentMethodInterfaceFactory $paymentMethodFactory = null;

    private ?Data $paymentDataHelper = null;

    protected function setUp(): void
    {
        $this->objectManager = Bootstrap::getObjectManager();
        $this->paymentMethodRepository = $this->objectManager->get(OutOfProcessPaymentMethodRepositoryInterface::class);
        $this->paymentMethodFactory = $this->objectManager->get(OutOfProcessPaymentMethodInterfaceFactory::class);
        $this->paymentDataHelper = Bootstrap::getObjectManager()->get(\Magento\Payment\Helper\Data::class);

    }

    public function testGetPaymentMethods()
    {
        // Obtain the list of payment methods
        $methods = $this->paymentDataHelper->getPaymentMethods();
        $numberOfPaymentMethodsBeforeAddOopPaymentMethods = count($methods);

        // Create a new oop payment method
        $newPaymentMethod = $this->paymentMethodFactory->create();
        $newPaymentMethod->setCode(self::OOP_PAYMENT_METHOD_CODE);
        $this->paymentMethodRepository->createOrUpdate($newPaymentMethod);

        // Obtain the list of payment methods again
        $methods = $this->paymentDataHelper->getPaymentMethods();
        $numberOfPaymentMethodsAfterAddOopPaymentMethods = count($methods);

        // Assert that the number of payment methods has increased so plugin AddOutOfProcessPaymentMethod is working
        $this->assertEquals(
            $numberOfPaymentMethodsBeforeAddOopPaymentMethods + 1,
            $numberOfPaymentMethodsAfterAddOopPaymentMethods
        );

        // Assert that the new payment method is in the list of payment methods
        $this->assertArrayHasKey(self::OOP_PAYMENT_METHOD_CODE, $methods);
    }
}
