<?php

/************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2024 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 * ************************************************************************
 */

declare(strict_types=1);

namespace Magento\OutOfProcessPaymentMethods\Model\Plugin;

use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\OutOfProcessPaymentMethods\Model\OutOfProcessAdditionalDataProviderPool;
use Magento\Quote\Model\Quote;
use Magento\Sales\Model\Order\Payment\Repository as PaymentRepository;

use Psr\Log\LoggerInterface;

/**
 * Set additionalInformation on payment for Hosted Pro method
 */
class SetPaymentMethodOnCartPlugin
{
    /**
     * @param LoggerInterface $logger
     * @param PaymentRepository $paymentRepository
     * @param OutOfProcessAdditionalDataProviderPool $additionalDataProviderPool
     */
    public function __construct(
        private readonly LoggerInterface                        $logger,
        private readonly PaymentRepository                      $paymentRepository,
        private readonly OutOfProcessAdditionalDataProviderPool $additionalDataProviderPool
    ) {
    }

    /**
     * Add payment information from  provider response to payment if present when setMethodOnCart is called.
     *
     * @param \Magento\QuoteGraphQl\Model\Cart\SetPaymentMethodOnCart $subject
     * @param mixed $result
     * @param Quote $cart
     * @param array $paymentMethodData
     * @return void
     * @throws GraphQlInputException
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterExecute(
        \Magento\QuoteGraphQl\Model\Cart\SetPaymentMethodOnCart $subject,
        $result,
        Quote $cart,
        array $paymentMethodData
    ): void {

        $this->logger->debug("SetPaymentMethodOnCartPlugin::paymentMethodData");

        $code = $paymentMethodData['code'];
        $paymentInformation = $this->additionalDataProviderPool->getPaymentInformation($paymentMethodData);

        if (!empty($code) && !empty($paymentInformation)) {

            $this->logger->debug("paymentInformation is present, adding to payment in additionalInformation.");

            $payment = $cart->getPayment();
            foreach ($paymentInformation as $data) {
                $payment->setAdditionalInformation($data['key'], $data['value']);
            }

            $payment->save();
        }
    }
}
